/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import io.v.v23.verror.VException;
import io.v.v23.vom.BinaryDecoder;
import io.v.v23.vom.BinaryEncoder;
import io.v.v23.vom.ConversionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;

public class VomUtil {
    public static byte[] encode(Object value, Type type) throws VException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder(out);
        try {
            encoder.encodeValue(type, value);
        }
        catch (IOException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
        return out.toByteArray();
    }

    public static byte[] encode(Object value, VdlType type) throws VException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder(out);
        try {
            encoder.encodeValue(type, value);
        }
        catch (IOException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
        return out.toByteArray();
    }

    public static String encodeToString(Object value, Type type) throws VException {
        byte[] data = VomUtil.encode(value, type);
        return VomUtil.bytesToHexString(data);
    }

    public static byte[] encode(VdlValue value) throws VException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BinaryEncoder encoder = new BinaryEncoder(out);
        try {
            encoder.encodeValue(value);
        }
        catch (IOException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
        return out.toByteArray();
    }

    public static Object decode(byte[] data, Type type) throws VException {
        BinaryDecoder decoder = new BinaryDecoder(new ByteArrayInputStream(data));
        try {
            return decoder.decodeValue(type);
        }
        catch (IOException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
        catch (ConversionException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
    }

    public static Object decode(byte[] data) throws VException {
        BinaryDecoder decoder = new BinaryDecoder(new ByteArrayInputStream(data));
        try {
            return decoder.decodeValue();
        }
        catch (IOException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
        catch (ConversionException e) {
            VException ve = new VException(e.getMessage());
            ve.initCause(e);
            throw ve;
        }
    }

    public static Object decodeFromString(String hex, Type type) throws VException {
        byte[] data = VomUtil.hexStringToBytes(hex);
        return VomUtil.decode(data, type);
    }

    public static VdlValue valueOf(Object obj, Type type) throws VException {
        byte[] data = VomUtil.encode(obj, type);
        return (VdlValue)VomUtil.decode(data, VdlValue.class);
    }

    public static VdlValue valueOf(Object obj, VdlType type) throws VException {
        byte[] data = VomUtil.encode(obj, type);
        return (VdlValue)VomUtil.decode(data, VdlValue.class);
    }

    public static String bytesToHexString(byte[] data) {
        StringBuilder builder = new StringBuilder();
        for (byte b : data) {
            builder.append(String.format("%02x", b));
        }
        return builder.toString();
    }

    public static byte[] hexStringToBytes(String hex) throws VException {
        if (hex.length() % 2 != 0) {
            throw new VException("Hex strings must be multiples of 2 in length");
        }
        int outLen = hex.length() / 2;
        byte[] dat = new byte[outLen];
        for (int i = 0; i < outLen; ++i) {
            dat[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return dat;
    }
}

