/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlType;
import io.v.v23.vom.BinaryUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TypeCompatibility {
    public static boolean compatible(VdlType a, VdlType b) {
        HashMap<VdlType, Set<VdlType>> seen = new HashMap<VdlType, Set<VdlType>>();
        return TypeCompatibility.compatible(a, b, seen);
    }

    private static boolean compatible(VdlType a, VdlType b, Map<VdlType, Set<VdlType>> seen) {
        if (a.getKind() == Kind.OPTIONAL) {
            a = a.getElem();
        }
        if (b.getKind() == Kind.OPTIONAL) {
            b = b.getElem();
        }
        if (a == b) {
            return true;
        }
        Set<VdlType> set = seen.get(a);
        if (set == null) {
            set = new HashSet<VdlType>();
            seen.put(a, set);
        }
        if (set.contains(b)) {
            return true;
        }
        set.add(b);
        if (a.getKind() == Kind.ANY || b.getKind() == Kind.ANY) {
            return true;
        }
        if (TypeCompatibility.isNumber(a)) {
            return TypeCompatibility.isNumber(b);
        }
        if (a.getKind() == Kind.BOOL) {
            return b.getKind() == Kind.BOOL;
        }
        if (a.getKind() == Kind.TYPEOBJECT) {
            return b.getKind() == Kind.TYPEOBJECT;
        }
        boolean aIsBytes = TypeCompatibility.isStringEnumBytes(a);
        boolean bIsBytes = TypeCompatibility.isStringEnumBytes(b);
        if (aIsBytes || bIsBytes) {
            return aIsBytes && bIsBytes;
        }
        switch (a.getKind()) {
            case ARRAY: 
            case LIST: {
                if (b.getKind() == Kind.ARRAY || b.getKind() == Kind.LIST) {
                    return TypeCompatibility.compatible(a.getElem(), b.getElem(), seen);
                }
                return false;
            }
            case MAP: 
            case SET: {
                switch (b.getKind()) {
                    case MAP: 
                    case SET: {
                        return TypeCompatibility.mapsCompatible(a, b, seen);
                    }
                    case STRUCT: {
                        return TypeCompatibility.structAndMapCompatible(b, a, seen);
                    }
                }
                return false;
            }
            case STRUCT: {
                switch (b.getKind()) {
                    case MAP: 
                    case SET: {
                        return TypeCompatibility.structAndMapCompatible(a, b, seen);
                    }
                    case STRUCT: {
                        if (TypeCompatibility.isEmptyStruct(a) || TypeCompatibility.isEmptyStruct(b)) {
                            return true;
                        }
                        return TypeCompatibility.fieldsCompatible(a, b, seen);
                    }
                }
                return false;
            }
            case UNION: {
                if (b.getKind() == Kind.UNION) {
                    return TypeCompatibility.fieldsCompatible(a, b, seen);
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unsupported VDL type " + a);
    }

    private static boolean isNumber(VdlType type) {
        switch (type.getKind()) {
            case BYTE: 
            case FLOAT32: 
            case FLOAT64: 
            case INT16: 
            case INT32: 
            case INT64: 
            case UINT16: 
            case UINT32: 
            case UINT64: {
                return true;
            }
        }
        return false;
    }

    private static boolean isStringEnumBytes(VdlType type) {
        return type.getKind() == Kind.STRING || type.getKind() == Kind.ENUM || BinaryUtil.isBytes(type);
    }

    private static boolean isEmptyStruct(VdlType type) {
        return type.getKind() == Kind.STRUCT && type.getFields().isEmpty();
    }

    private static boolean mapsCompatible(VdlType a, VdlType b, Map<VdlType, Set<VdlType>> seen) {
        if (!TypeCompatibility.compatible(a.getKey(), b.getKey(), seen)) {
            return false;
        }
        VdlType aElem = a.getKind() == Kind.MAP ? a.getElem() : Types.BOOL;
        VdlType bElem = b.getKind() == Kind.MAP ? b.getElem() : Types.BOOL;
        return TypeCompatibility.compatible(aElem, bElem, seen);
    }

    private static boolean structAndMapCompatible(VdlType struct, VdlType map, Map<VdlType, Set<VdlType>> seen) {
        if (TypeCompatibility.isEmptyStruct(struct) || !TypeCompatibility.compatible(Types.STRING, map.getKey(), seen)) {
            return false;
        }
        VdlType elem = map.getKind() == Kind.MAP ? map.getElem() : Types.BOOL;
        for (VdlField field : struct.getFields()) {
            if (TypeCompatibility.compatible(elem, field.getType(), seen)) continue;
            return false;
        }
        return true;
    }

    private static boolean fieldsCompatible(VdlType a, VdlType b, Map<VdlType, Set<VdlType>> seen) {
        if (a.getFields().size() > b.getFields().size()) {
            return TypeCompatibility.fieldsCompatible(b, a, seen);
        }
        HashMap<String, VdlType> aFields = new HashMap<String, VdlType>();
        for (VdlField field : a.getFields()) {
            aFields.put(field.getName(), field.getType());
        }
        boolean fieldMatched = false;
        for (VdlField field : b.getFields()) {
            VdlType type = (VdlType)aFields.get(field.getName());
            if (type == null) continue;
            if (!TypeCompatibility.compatible(type, field.getType())) {
                return false;
            }
            fieldMatched = true;
        }
        return fieldMatched;
    }
}

