/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlEnum;
import io.v.v23.vdl.VdlList;
import io.v.v23.vdl.VdlMap;
import io.v.v23.vdl.VdlSet;
import io.v.v23.vdl.VdlStruct;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vom.ConversionException;
import io.v.v23.vom.ConversionTarget;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class ReflectUtil {
    ReflectUtil() {
    }

    static Object createPrimitive(ConversionTarget target, Object value, Class<?> valueType) throws ConversionException {
        Class<?> targetClass = target.getTargetClass();
        try {
            if (targetClass.getSuperclass() == VdlValue.class) {
                return targetClass.getConstructor(VdlType.class, valueType).newInstance(target.getVdlType(), value);
            }
            if (VdlValue.class.isAssignableFrom(targetClass)) {
                return targetClass.getConstructor(valueType).newInstance(value);
            }
            return value;
        }
        catch (Exception e) {
            throw new ConversionException(value, targetClass, e);
        }
    }

    static VdlEnum createEnum(ConversionTarget target, String label) throws ConversionException {
        Class<?> targetClass = target.getTargetClass();
        if (targetClass == VdlEnum.class) {
            return new VdlEnum(target.getVdlType(), label);
        }
        try {
            return (VdlEnum)targetClass.getMethod("valueOf", String.class).invoke(null, label);
        }
        catch (Exception e) {
            throw new ConversionException((Object)label, targetClass, e);
        }
    }

    private static Object createNamedGeneric(Class<?> targetClass, Object impl) throws ConversionException {
        try {
            if (VdlArray.class.isAssignableFrom(targetClass)) {
                return ReflectUtil.construct(targetClass, impl.getClass(), impl);
            }
            if (VdlList.class.isAssignableFrom(targetClass)) {
                return ReflectUtil.construct(targetClass, List.class, impl);
            }
            if (VdlMap.class.isAssignableFrom(targetClass)) {
                return ReflectUtil.construct(targetClass, Map.class, impl);
            }
            if (VdlSet.class.isAssignableFrom(targetClass)) {
                return ReflectUtil.construct(targetClass, Set.class, impl);
            }
        }
        catch (Exception e) {
            throw new ConversionException(impl, targetClass, e);
        }
        throw new ConversionException(impl, targetClass);
    }

    private static Object construct(Class<?> targetClass, Class<?> ctorParamType, Object ... ctorArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<?> ctor = targetClass.getConstructor(ctorParamType);
        ctor.setAccessible(true);
        return ctor.newInstance(ctorArgs);
    }

    static Object createGeneric(ConversionTarget target, Object impl) throws ConversionException {
        Class<?> targetClass = target.getTargetClass();
        if (targetClass == VdlArray.class) {
            return new VdlArray<Object>(target.getVdlType(), (Object[])impl);
        }
        if (targetClass == VdlList.class) {
            return new VdlList(target.getVdlType(), (List)impl);
        }
        if (targetClass == VdlSet.class) {
            return new VdlSet(target.getVdlType(), (Set)impl);
        }
        if (targetClass == VdlMap.class) {
            return new VdlMap(target.getVdlType(), (Map)impl);
        }
        if (VdlValue.class.isAssignableFrom(targetClass)) {
            return ReflectUtil.createNamedGeneric(targetClass, impl);
        }
        return impl;
    }

    static Object createStruct(ConversionTarget target) throws ConversionException {
        Class<?> targetClass = target.getTargetClass();
        if (targetClass == VdlStruct.class) {
            return new VdlStruct(target.getVdlType());
        }
        try {
            Constructor<?> ctor = targetClass.getConstructor(new Class[0]);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ConversionException((Object)target.getVdlType(), targetClass, e);
        }
    }

    static Class<?> getRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ReflectUtil.getRawClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Class<?> component = ReflectUtil.getRawClass(((GenericArrayType)type).getGenericComponentType());
            return Array.newInstance(component, 0).getClass();
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Type getElementType(Type type, int index) throws ConversionException {
        Type[] types = new Type[]{};
        if (type instanceof Class) {
            Class klass = (Class)type;
            if (!klass.isArray()) return ReflectUtil.getElementType(klass.getGenericSuperclass(), index);
            types = new Type[]{klass.getComponentType()};
        } else if (type instanceof ParameterizedType) {
            types = ((ParameterizedType)type).getActualTypeArguments();
        } else if (type instanceof GenericArrayType) {
            types = new Type[]{((GenericArrayType)type).getGenericComponentType()};
        }
        if (index >= 0 && index < types.length) return types[index];
        throw new ConversionException("Type " + type + " has no element at index " + index);
    }

    static void setArrayValue(Object array, int index, Object value, Class<?> elementClass) {
        if (elementClass == Boolean.TYPE) {
            Array.setBoolean(array, index, (Boolean)value);
        } else if (elementClass == Byte.TYPE) {
            Array.setByte(array, index, (Byte)value);
        } else if (elementClass == Double.TYPE) {
            Array.setDouble(array, index, (Double)value);
        } else if (elementClass == Float.TYPE) {
            Array.setFloat(array, index, ((Float)value).floatValue());
        } else if (elementClass == Integer.TYPE) {
            Array.setInt(array, index, (Integer)value);
        } else if (elementClass == Long.TYPE) {
            Array.setLong(array, index, (Long)value);
        } else if (elementClass == Short.TYPE) {
            Array.setShort(array, index, (Short)value);
        } else {
            Array.set(array, index, value);
        }
    }
}

