/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlByte;
import io.v.v23.vdl.VdlEnum;
import io.v.v23.vdl.VdlString;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vom.ConversionException;
import io.v.v23.vom.ConversionTarget;
import io.v.v23.vom.ReflectUtil;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;

final class ConvertUtil {
    private static long DOUBLE_MAX_LOSSLESS_INTEGER = 0x20000000000000L;
    private static long DOUBLE_MIN_LOSSLESS_INTEGER = -9007199254740992L;
    private static long FLOAT_MAX_LOSSLESS_INTEGER = 0x1000000L;
    private static long FLOAT_MIN_LOSSLESS_INTEGER = -16777216L;

    ConvertUtil() {
    }

    static boolean hasOverflowUint(long x, long bitlen) {
        long shift = 64L - bitlen;
        return x != x << (int)shift >>> (int)shift;
    }

    static boolean hasOverflowInt(long x, long bitlen) {
        long shift = 64L - bitlen;
        return x != x << (int)shift >> (int)shift;
    }

    static boolean canConvertUintToInt(long x, long bitlen) {
        return x >= 0L && !ConvertUtil.hasOverflowInt(x, bitlen);
    }

    static boolean canConvertIntToUint(long x, long bitlen) {
        return x >= 0L && !ConvertUtil.hasOverflowUint(x, bitlen);
    }

    static boolean canConvertUintToFloat(long x, long bitlen) {
        if (x < 0L) {
            return false;
        }
        switch ((int)bitlen) {
            case 32: {
                return x <= FLOAT_MAX_LOSSLESS_INTEGER;
            }
        }
        return x <= DOUBLE_MAX_LOSSLESS_INTEGER;
    }

    static boolean canConvertIntToFloat(long x, long bitlen) {
        switch ((int)bitlen) {
            case 32: {
                return FLOAT_MIN_LOSSLESS_INTEGER <= x && x <= FLOAT_MAX_LOSSLESS_INTEGER;
            }
        }
        return DOUBLE_MIN_LOSSLESS_INTEGER <= x && x <= DOUBLE_MAX_LOSSLESS_INTEGER;
    }

    static long explicitConvertFloatToUint(double x) {
        if (x < (double)(DOUBLE_MAX_LOSSLESS_INTEGER * 4L)) {
            return (long)x;
        }
        return (long)(x / 2.0) << 1;
    }

    static boolean canConvertFloatToUint(double x, long bitlen) {
        if (x < 0.0) {
            return false;
        }
        if (x < (double)(DOUBLE_MAX_LOSSLESS_INTEGER * 4L)) {
            return ConvertUtil.canConvertFloatToInt(x, bitlen);
        }
        return ConvertUtil.canConvertFloatToInt(x / 2.0, bitlen);
    }

    static boolean canConvertFloatToInt(double x, long bitlen) {
        long intPart = (long)x;
        double fracPart = x - (double)intPart;
        return fracPart == 0.0 && x >= -9.223372036854776E18 && x <= 9.223372036854776E18 && !ConvertUtil.hasOverflowInt(intPart, bitlen);
    }

    private static Object convertUint(long value, ConversionTarget target) throws ConversionException {
        switch (target.getKind()) {
            case BYTE: {
                if (ConvertUtil.hasOverflowUint(value, 8L)) break;
                return ReflectUtil.createPrimitive(target, (byte)value, Byte.TYPE);
            }
            case UINT16: {
                if (ConvertUtil.hasOverflowUint(value, 16L)) break;
                return ReflectUtil.createPrimitive(target, (short)value, Short.TYPE);
            }
            case UINT32: {
                if (ConvertUtil.hasOverflowUint(value, 32L)) break;
                return ReflectUtil.createPrimitive(target, (int)value, Integer.TYPE);
            }
            case UINT64: {
                return ReflectUtil.createPrimitive(target, value, Long.TYPE);
            }
            default: {
                if (!ConvertUtil.canConvertUintToInt(value, 64L)) break;
                return ConvertUtil.convertInt(value, target);
            }
        }
        throw new ConversionException("Can't convert " + value + " to " + target.getTargetType());
    }

    private static Object convertInt(long value, ConversionTarget target) throws ConversionException {
        switch (target.getKind()) {
            case INT8: {
                if (ConvertUtil.hasOverflowInt(value, 8L)) break;
                return ReflectUtil.createPrimitive(target, (byte)value, Byte.TYPE);
            }
            case INT16: {
                if (ConvertUtil.hasOverflowInt(value, 16L)) break;
                return ReflectUtil.createPrimitive(target, (short)value, Short.TYPE);
            }
            case INT32: {
                if (ConvertUtil.hasOverflowInt(value, 32L)) break;
                return ReflectUtil.createPrimitive(target, (int)value, Integer.TYPE);
            }
            case INT64: {
                return ReflectUtil.createPrimitive(target, value, Long.TYPE);
            }
            case FLOAT32: {
                if (!ConvertUtil.canConvertIntToFloat(value, 32L)) break;
                return ConvertUtil.convertDouble(value, target);
            }
            default: {
                if (!ConvertUtil.canConvertIntToFloat(value, 64L)) break;
                return ConvertUtil.convertDouble(value, target);
            }
        }
        throw new ConversionException("Can't convert " + value + " to " + target.getTargetType());
    }

    private static Object convertDouble(double value, ConversionTarget target) throws ConversionException {
        switch (target.getKind()) {
            case FLOAT32: {
                return ReflectUtil.createPrimitive(target, Float.valueOf((float)value), Float.TYPE);
            }
            case FLOAT64: {
                return ReflectUtil.createPrimitive(target, value, Double.TYPE);
            }
        }
        throw new ConversionException("Can't convert " + value + " to " + target.getTargetType());
    }

    static Object convertFromUint(long value, ConversionTarget target) throws ConversionException {
        return ConvertUtil.convertUint(value, target);
    }

    static Object convertFromByte(byte value, ConversionTarget target) throws ConversionException {
        return ConvertUtil.convertUint((long)value & 0xFFL, target);
    }

    static Object convertFromInt(long value, ConversionTarget target) throws ConversionException {
        if (ConvertUtil.canConvertIntToUint(value, 64L)) {
            return ConvertUtil.convertFromUint(value, target);
        }
        return ConvertUtil.convertInt(value, target);
    }

    static Object convertFromDouble(double value, ConversionTarget target) throws ConversionException {
        switch (target.getKind()) {
            case UINT64: {
                if (!ConvertUtil.canConvertFloatToUint(value, 64L)) break;
                return ConvertUtil.convertFromUint(ConvertUtil.explicitConvertFloatToUint(value), target);
            }
            case FLOAT32: 
            case FLOAT64: {
                break;
            }
            default: {
                if (!ConvertUtil.canConvertFloatToInt(value, 64L)) break;
                return ConvertUtil.convertFromInt((long)value, target);
            }
        }
        return ConvertUtil.convertDouble(value, target);
    }

    static Object convertFromBytes(byte[] bytes, ConversionTarget target) throws ConversionException {
        Object elemType;
        Class<?> targetClass = target.getTargetClass();
        if (targetClass.equals(byte[].class)) {
            return bytes;
        }
        if (targetClass == String.class || VdlString.class.isAssignableFrom(targetClass)) {
            return ReflectUtil.createPrimitive(target, new String(bytes), String.class);
        }
        if (VdlEnum.class.isAssignableFrom(targetClass)) {
            return ReflectUtil.createEnum(target, new String(bytes));
        }
        int len = bytes.length;
        if (target.getKind() == Kind.ARRAY) {
            if (bytes.length > target.getVdlType().getLength()) {
                throw new ConversionException((Object)bytes, target.getTargetType(), "target array is too short");
            }
            len = target.getVdlType().getLength();
        }
        if ((elemType = ReflectUtil.getElementType(target.getTargetType(), 0)) == VdlValue.class) {
            elemType = VdlByte.class;
        }
        ConversionTarget element = new ConversionTarget((Type)elemType);
        if (targetClass.isArray() || VdlArray.class.isAssignableFrom(targetClass)) {
            Object data = Array.newInstance(element.getTargetClass(), len);
            for (int i = 0; i < bytes.length; ++i) {
                ReflectUtil.setArrayValue(data, i, ConvertUtil.convertFromByte(bytes[i], element), element.getTargetClass());
            }
            return ReflectUtil.createGeneric(target, data);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < bytes.length; ++i) {
            list.add(ConvertUtil.convertFromByte(bytes[i], element));
        }
        return ReflectUtil.createGeneric(target, list);
    }
}

