/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import com.google.common.collect.ImmutableMap;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlType;
import io.v.v23.vom.Constants;
import io.v.v23.vom.TypeId;
import java.util.Map;

public final class BootstrapType {
    private static final Map<VdlType, TypeId> typeToId = ImmutableMap.builder().put((Object)Types.BOOL, (Object)Constants.WIRE_ID_BOOL).put((Object)Types.BYTE, (Object)Constants.WIRE_ID_BYTE).put((Object)Types.STRING, (Object)Constants.WIRE_ID_STRING).put((Object)Types.UINT16, (Object)Constants.WIRE_ID_UINT_16).put((Object)Types.UINT32, (Object)Constants.WIRE_ID_UINT_32).put((Object)Types.UINT64, (Object)Constants.WIRE_ID_UINT_64).put((Object)Types.INT8, (Object)Constants.WIRE_ID_INT_8).put((Object)Types.INT16, (Object)Constants.WIRE_ID_INT_16).put((Object)Types.INT32, (Object)Constants.WIRE_ID_INT_32).put((Object)Types.INT64, (Object)Constants.WIRE_ID_INT_64).put((Object)Types.FLOAT32, (Object)Constants.WIRE_ID_FLOAT_32).put((Object)Types.FLOAT64, (Object)Constants.WIRE_ID_FLOAT_64).put((Object)Types.TYPEOBJECT, (Object)Constants.WIRE_ID_TYPE_OBJECT).put((Object)Types.ANY, (Object)Constants.WIRE_ID_ANY).put((Object)Types.listOf(Types.BYTE), (Object)Constants.WIRE_ID_BYTE_LIST).put((Object)Types.listOf(Types.STRING), (Object)Constants.WIRE_ID_STRING_LIST).build();
    private static final Map<TypeId, VdlType> idToType;

    public static VdlType getBootstrapType(TypeId typeId) {
        return idToType.get(typeId);
    }

    public static TypeId getBootstrapTypeId(VdlType type) {
        return typeToId.get(type);
    }

    static {
        ImmutableMap.Builder idToTypeBuilder = ImmutableMap.builder();
        for (Map.Entry<VdlType, TypeId> typeToIdEntry : typeToId.entrySet()) {
            idToTypeBuilder.put((Object)typeToIdEntry.getValue(), (Object)typeToIdEntry.getKey());
        }
        idToType = idToTypeBuilder.build();
    }
}

