/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlType;
import io.v.v23.vom.CorruptVomStreamException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;

public final class BinaryUtil {
    static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final String END_OF_STREAM_MESSAGE = "End of stream prematurely reached.";

    public static boolean encodeUint(OutputStream out, long value) throws IOException {
        if ((value & 0x7FL) == value) {
            out.write((byte)value);
            return value != 0L;
        }
        int len = 0;
        while ((value >>> len * 8 | 0xFFL) != 255L) {
            ++len;
        }
        out.write(-(++len));
        while (len > 0) {
            out.write((byte)(value >>> --len * 8));
        }
        return true;
    }

    public static boolean encodeUint(OutputStream out, int value) throws IOException {
        return BinaryUtil.encodeUint(out, (long)value & 0xFFFFFFFFL);
    }

    public static boolean encodeUint(OutputStream out, short value) throws IOException {
        return BinaryUtil.encodeUint(out, (long)value & 0xFFFFL);
    }

    public static long decodeUint(InputStream in) throws IOException {
        int firstByte = in.read();
        if (firstByte == -1) {
            throw new CorruptVomStreamException(END_OF_STREAM_MESSAGE);
        }
        if ((firstByte & 0x7F) == firstByte) {
            return firstByte;
        }
        int len = -((int)firstByte);
        if (len > 8) {
            throw new CorruptVomStreamException("Invalid long byte length " + len);
        }
        long value = 0L;
        while (len > 0) {
            --len;
            int nextByte = in.read();
            if (nextByte == -1) {
                throw new CorruptVomStreamException(END_OF_STREAM_MESSAGE);
            }
            value = value << 8 | (long)nextByte;
        }
        return value;
    }

    public static boolean encodeInt(OutputStream out, long value) throws IOException {
        if (value < 0L) {
            return BinaryUtil.encodeUint(out, (value ^ 0xFFFFFFFFFFFFFFFFL) << 1 | 1L);
        }
        return BinaryUtil.encodeUint(out, value << 1);
    }

    public static long decodeInt(InputStream in) throws IOException {
        long uint = BinaryUtil.decodeUint(in);
        if ((uint & 1L) == 1L) {
            return uint >>> 1 ^ 0xFFFFFFFFFFFFFFFFL;
        }
        return uint >>> 1;
    }

    public static boolean encodeDouble(OutputStream out, double value) throws IOException {
        return BinaryUtil.encodeUint(out, Long.reverseBytes(Double.doubleToLongBits(value)));
    }

    public static double decodeDouble(InputStream in) throws IOException {
        return Double.longBitsToDouble(Long.reverseBytes(BinaryUtil.decodeUint(in)));
    }

    public static boolean decodeBoolean(InputStream in) throws IOException {
        int nextByte = in.read();
        if (nextByte == -1) {
            throw new CorruptVomStreamException(END_OF_STREAM_MESSAGE);
        }
        return nextByte != 0;
    }

    public static void encodeBytes(OutputStream out, byte[] data) throws IOException {
        BinaryUtil.encodeUint(out, data.length);
        out.write(data);
    }

    public static byte[] decodeBytes(InputStream in, int len) throws IOException {
        if (len == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[len];
        if (in.read(bytes) != bytes.length) {
            throw new CorruptVomStreamException(END_OF_STREAM_MESSAGE);
        }
        return bytes;
    }

    public static boolean isBytes(VdlType type) {
        return (type.getKind() == Kind.ARRAY || type.getKind() == Kind.LIST) && type.getElem().getKind() == Kind.BYTE;
    }

    public static boolean hasBinaryMsgLen(VdlType type) {
        if (BinaryUtil.isBytes(type)) {
            return false;
        }
        switch (type.getKind()) {
            case ANY: 
            case ARRAY: 
            case LIST: 
            case MAP: 
            case OPTIONAL: 
            case SET: 
            case STRUCT: 
            case UNION: {
                return true;
            }
        }
        return false;
    }

    static boolean hasTypeObject(VdlType t) {
        return BinaryUtil.hasTypeObjectInternal(t, new HashSet<VdlType>());
    }

    private static boolean hasTypeObjectInternal(VdlType t, HashSet<VdlType> seen) {
        if (seen.contains(t)) {
            return false;
        }
        seen.add(t);
        switch (t.getKind()) {
            case TYPEOBJECT: {
                return true;
            }
            case ARRAY: 
            case LIST: 
            case OPTIONAL: {
                return BinaryUtil.hasTypeObjectInternal(t.getElem(), seen);
            }
            case SET: {
                return BinaryUtil.hasTypeObjectInternal(t.getKey(), seen);
            }
            case MAP: {
                return BinaryUtil.hasTypeObjectInternal(t.getKey(), seen) || BinaryUtil.hasTypeObjectInternal(t.getElem(), seen);
            }
            case STRUCT: 
            case UNION: {
                for (VdlField fld : t.getFields()) {
                    if (!BinaryUtil.hasTypeObjectInternal(fld.getType(), seen)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    static boolean hasAny(VdlType t) {
        return BinaryUtil.hasAnyInternal(t, new HashSet<VdlType>());
    }

    private static boolean hasAnyInternal(VdlType t, HashSet<VdlType> seen) {
        if (seen.contains(t)) {
            return false;
        }
        seen.add(t);
        switch (t.getKind()) {
            case ANY: {
                return true;
            }
            case ARRAY: 
            case LIST: 
            case OPTIONAL: {
                return BinaryUtil.hasAnyInternal(t.getElem(), seen);
            }
            case SET: {
                return BinaryUtil.hasAnyInternal(t.getKey(), seen);
            }
            case MAP: {
                return BinaryUtil.hasAnyInternal(t.getKey(), seen) || BinaryUtil.hasAnyInternal(t.getElem(), seen);
            }
            case STRUCT: 
            case UNION: {
                for (VdlField fld : t.getFields()) {
                    if (!BinaryUtil.hasAnyInternal(fld.getType(), seen)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static byte[] getBytes(String value) {
        if (value == null) {
            value = "";
        }
        return value.getBytes(UTF8_CHARSET);
    }

    public static String firstCharToUpper(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static String firstCharToLower(String str) {
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }
}

