/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.NativeTypes;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlBool;
import io.v.v23.vdl.VdlByte;
import io.v.v23.vdl.VdlEnum;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlFloat32;
import io.v.v23.vdl.VdlFloat64;
import io.v.v23.vdl.VdlInt16;
import io.v.v23.vdl.VdlInt32;
import io.v.v23.vdl.VdlInt64;
import io.v.v23.vdl.VdlInt8;
import io.v.v23.vdl.VdlList;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlString;
import io.v.v23.vdl.VdlStruct;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint16;
import io.v.v23.vdl.VdlUint32;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlUnion;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vom.BinaryUtil;
import io.v.v23.vom.BootstrapType;
import io.v.v23.vom.Constants;
import io.v.v23.vom.EncodingStream;
import io.v.v23.vom.TypeId;
import io.v.v23.vom.Version;
import io.v.v23.vom.WireArray;
import io.v.v23.vom.WireEnum;
import io.v.v23.vom.WireField;
import io.v.v23.vom.WireList;
import io.v.v23.vom.WireMap;
import io.v.v23.vom.WireNamed;
import io.v.v23.vom.WireOptional;
import io.v.v23.vom.WireSet;
import io.v.v23.vom.WireStruct;
import io.v.v23.vom.WireType;
import io.v.v23.vom.WireUnion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryEncoder {
    private final EncodingStream valueBuffer = new EncodingStream();
    private final EncodingStream typeBuffer = new EncodingStream();
    private final OutputStream out;
    private final Map<VdlType, TypeId> visitedTypes;
    private TypeId nextTypeId;
    private boolean binaryMagicByteWritten;
    private Version version;
    private List<Long> typeIds;
    private List<Long> anyLens;

    public BinaryEncoder(OutputStream out) {
        this(out, Constants.DEFAULT_VERSION);
    }

    public BinaryEncoder(OutputStream out, Version version) {
        this.out = out;
        this.visitedTypes = new HashMap<VdlType, TypeId>();
        this.nextTypeId = Constants.WIRE_ID_FIRST_USER_TYPE;
        this.binaryMagicByteWritten = false;
        this.version = version;
    }

    public void encodeValue(VdlType type, Object value) throws IOException {
        if (!this.binaryMagicByteWritten) {
            this.binaryMagicByteWritten = true;
            this.out.write(this.version.getValue());
        }
        this.valueBuffer.reset();
        this.typeIds = new ArrayList<Long>();
        this.anyLens = new ArrayList<Long>();
        TypeId typeId = this.getType(type);
        this.writeValue(this.valueBuffer, value, type);
        this.writeMessage(this.valueBuffer, BinaryUtil.hasAny(type), BinaryUtil.hasTypeObject(type), false, typeId.getValue(), BinaryUtil.hasBinaryMsgLen(type));
    }

    public void encodeValue(Type type, Object value) throws IOException {
        this.encodeValue(Types.getVdlTypeFromReflect(type), value);
    }

    public void encodeValue(VdlValue value) throws IOException {
        this.encodeValue(value.vdlType(), (Object)value);
    }

    private void writeMessage(ByteArrayOutputStream buffer, boolean hasAny, boolean hasTypeObject, boolean typeIncomplete, long messageId, boolean encodeLength) throws IOException {
        if (this.version != Constants.VERSION_80 && typeIncomplete) {
            this.out.write(-30);
        }
        BinaryUtil.encodeInt(this.out, messageId);
        if (this.version != Constants.VERSION_80 && (hasAny || hasTypeObject) && messageId > 0L) {
            BinaryUtil.encodeUint(this.out, this.typeIds.size());
            for (Long id : this.typeIds) {
                BinaryUtil.encodeUint(this.out, id);
            }
            this.typeIds = null;
        }
        if (this.version != Constants.VERSION_80 && hasAny && messageId > 0L) {
            BinaryUtil.encodeUint(this.out, this.anyLens.size());
            for (Long len : this.anyLens) {
                BinaryUtil.encodeUint(this.out, len);
            }
            this.anyLens = null;
        }
        if (encodeLength) {
            BinaryUtil.encodeUint(this.out, buffer.size());
        }
        buffer.writeTo(this.out);
    }

    private TypeId getType(VdlType type) throws IOException {
        return this.getTypeInternal(type, new HashSet<VdlType>());
    }

    private TypeId getTypeInternal(VdlType type, Set<VdlType> pending) throws IOException {
        TypeId typeId = BootstrapType.getBootstrapTypeId(type);
        if (typeId != null) {
            return typeId;
        }
        if (this.visitedTypes.containsKey(type)) {
            return this.visitedTypes.get(type);
        }
        return this.encodeType(type, pending);
    }

    private TypeId encodeType(VdlType type, Set<VdlType> pending) throws IOException {
        pending.add(type);
        TypeId typeId = this.nextTypeId;
        this.nextTypeId = new TypeId(this.nextTypeId.getValue() + 1L);
        this.visitedTypes.put(type, typeId);
        WireType wireType = this.convertToWireType(type, pending);
        pending.remove(type);
        boolean incomplete = this.typeIncomplete(type, pending, new HashSet<VdlType>());
        this.typeBuffer.reset();
        this.writeValue(this.typeBuffer, wireType, wireType.vdlType());
        this.writeMessage(this.typeBuffer, BinaryUtil.hasAny(type), BinaryUtil.hasTypeObject(type), incomplete, -typeId.getValue(), true);
        return typeId;
    }

    private WireType convertToWireType(VdlType type, Set<VdlType> pending) throws IOException {
        switch (type.getKind()) {
            case INT8: {
                if (this.version == Constants.VERSION_80) {
                    throw new RuntimeException("int8 not supported in VOM version 80");
                }
            }
            case BOOL: 
            case BYTE: 
            case UINT16: 
            case UINT32: 
            case UINT64: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT32: 
            case FLOAT64: 
            case STRING: {
                return new WireType.NamedT(new WireNamed(type.getName(), this.getTypeInternal(Types.primitiveTypeFromKind(type.getKind()), pending)));
            }
            case ARRAY: {
                return new WireType.ArrayT(new WireArray(type.getName(), this.getTypeInternal(type.getElem(), pending), new VdlUint64(type.getLength())));
            }
            case ENUM: {
                return new WireType.EnumT(new WireEnum(type.getName(), type.getLabels()));
            }
            case LIST: {
                return new WireType.ListT(new WireList(type.getName(), this.getTypeInternal(type.getElem(), pending)));
            }
            case MAP: {
                return new WireType.MapT(new WireMap(type.getName(), this.getTypeInternal(type.getKey(), pending), this.getTypeInternal(type.getElem(), pending)));
            }
            case STRUCT: 
            case UNION: {
                ArrayList<WireField> wireFields = new ArrayList<WireField>();
                for (VdlField field : type.getFields()) {
                    wireFields.add(new WireField(field.getName(), this.getTypeInternal(field.getType(), pending)));
                }
                if (type.getKind() == Kind.UNION) {
                    return new WireType.UnionT(new WireUnion(type.getName(), wireFields));
                }
                return new WireType.StructT(new WireStruct(type.getName(), wireFields));
            }
            case SET: {
                return new WireType.SetT(new WireSet(type.getName(), this.getTypeInternal(type.getKey(), pending)));
            }
            case OPTIONAL: {
                return new WireType.OptionalT(new WireOptional(type.getName(), this.getTypeInternal(type.getElem(), pending)));
            }
        }
        throw new RuntimeException("Unknown wiretype for kind: " + (Object)((Object)type.getKind()));
    }

    private boolean typeIncomplete(VdlType type, Set<VdlType> pending, Set<VdlType> seen) {
        if (seen.contains(type)) {
            return false;
        }
        seen.add(type);
        if (pending.contains(type)) {
            return true;
        }
        switch (type.getKind()) {
            case ARRAY: 
            case LIST: 
            case OPTIONAL: {
                return this.typeIncomplete(type.getElem(), pending, seen);
            }
            case SET: {
                return this.typeIncomplete(type.getKey(), pending, seen);
            }
            case MAP: {
                return this.typeIncomplete(type.getKey(), pending, seen) || this.typeIncomplete(type.getElem(), pending, seen);
            }
            case STRUCT: 
            case UNION: {
                for (VdlField field : type.getFields()) {
                    if (!this.typeIncomplete(field.getType(), pending, seen)) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean writeValue(EncodingStream out, Object value, VdlType type) throws IOException {
        NativeTypes.Converter converter;
        if (value == null) {
            value = VdlValue.zeroValue(type);
        }
        if ((converter = Types.getNativeTypeConverter(value.getClass())) != null) {
            VdlValue vdlValue = converter.vdlValueFromNative(value);
            return this.writeValue(out, vdlValue, type);
        }
        switch (type.getKind()) {
            case ANY: {
                return this.writeVdlAny(out, value);
            }
            case ARRAY: {
                if (type.getElem().getKind() == Kind.BYTE) {
                    return this.writeVdlBytes(out, value, type);
                }
                return this.writeVdlArray(out, value);
            }
            case BOOL: {
                return this.writeVdlBool(out, value);
            }
            case ENUM: {
                return this.writeVdlEnum(out, value);
            }
            case FLOAT32: 
            case FLOAT64: {
                return this.writeVdlFloat(out, value);
            }
            case INT8: 
            case INT16: 
            case INT32: 
            case INT64: {
                if (type.getKind() == Kind.INT8 && this.version == Constants.VERSION_80) {
                    throw new RuntimeException("int8 not supported in VOM version 80");
                }
                return this.writeVdlInt(out, value);
            }
            case LIST: {
                if (type.getElem().getKind() == Kind.BYTE) {
                    return this.writeVdlBytes(out, value, type);
                }
                return this.writeVdlList(out, value, type);
            }
            case MAP: {
                return this.writeVdlMap(out, value, type);
            }
            case UNION: {
                return this.writeVdlUnion(out, value);
            }
            case OPTIONAL: {
                return this.writeVdlOptional(out, value);
            }
            case SET: {
                return this.writeVdlSet(out, value, type);
            }
            case STRING: {
                return this.writeVdlString(out, value);
            }
            case STRUCT: {
                return this.writeVdlStruct(out, value, type);
            }
            case BYTE: 
            case UINT16: 
            case UINT32: 
            case UINT64: {
                return this.writeVdlUint(out, value);
            }
            case TYPEOBJECT: {
                return this.writeVdlTypeObject(out, value);
            }
        }
        throw new RuntimeException("Unknown kind: " + (Object)((Object)type.getKind()));
    }

    private boolean writeVdlAny(EncodingStream out, Object value) throws IOException {
        this.expectClass(Kind.ANY, value, VdlAny.class);
        VdlAny anyValue = (VdlAny)value;
        Object elem = anyValue.getElem();
        if (elem != null) {
            long id = this.getType(anyValue.getElemType()).getValue();
            this.writeTypeId(out, id);
            int anyLenIndex = -1;
            long startPos = -1L;
            if (this.version != Constants.VERSION_80) {
                anyLenIndex = this.anyLens.size();
                BinaryUtil.encodeUint((OutputStream)out, anyLenIndex);
                this.anyLens.add(0L);
                startPos = out.getCount();
            }
            this.writeValue(out, elem, anyValue.getElemType());
            if (this.version != Constants.VERSION_80) {
                long endPos = out.getCount();
                this.anyLens.set(anyLenIndex, endPos - startPos);
            }
            return true;
        }
        this.writeVdlControlByte(out, (byte)-32);
        return false;
    }

    public void writeTypeId(OutputStream out, long id) throws IOException {
        if (this.version == Constants.VERSION_80) {
            BinaryUtil.encodeUint(out, id);
        } else {
            int index = this.typeIds.indexOf(id);
            if (index == -1) {
                index = this.typeIds.size();
                this.typeIds.add(id);
            }
            BinaryUtil.encodeUint(out, index);
        }
    }

    private boolean writeVdlArray(EncodingStream out, Object value) throws IOException {
        this.expectClass(Kind.ARRAY, value, VdlArray.class);
        VdlArray arrayValue = (VdlArray)value;
        BinaryUtil.encodeUint((OutputStream)out, 0);
        boolean isNonzero = false;
        for (Object elem : arrayValue) {
            isNonzero = this.writeValue(out, elem, arrayValue.vdlType().getElem()) || isNonzero;
        }
        return isNonzero;
    }

    private boolean writeVdlBool(OutputStream out, Object value) throws IOException {
        boolean val;
        if (value instanceof VdlBool) {
            val = ((VdlBool)value).getValue();
        } else if (value instanceof Boolean) {
            val = (Boolean)value;
        } else {
            throw new IOException("Unsupported VDL bool value (type " + value.getClass() + ", value " + value + ")");
        }
        int boolAsInt = 0;
        if (val) {
            boolAsInt = 1;
        }
        if (this.version == Constants.VERSION_80) {
            out.write(boolAsInt);
        } else {
            BinaryUtil.encodeUint(out, boolAsInt);
        }
        return val;
    }

    private boolean writeVdlByte(EncodingStream out, Object value) throws IOException {
        int byteValue;
        if (value instanceof VdlByte) {
            byteValue = ((VdlByte)value).getValue();
        } else if (value instanceof Byte) {
            byteValue = ((Byte)value).byteValue();
        } else {
            throw new IOException("Unsupported VDL byte value (type " + value.getClass() + ", value " + value + ")");
        }
        if (this.version == Constants.VERSION_80) {
            out.write(byteValue);
        } else {
            int fullValue = byteValue;
            if (fullValue < 0) {
                fullValue += 256;
            }
            BinaryUtil.encodeUint((OutputStream)out, fullValue);
        }
        return byteValue != 0;
    }

    private boolean writeVdlControlByte(EncodingStream out, Object value) throws IOException {
        byte byteValue;
        if (value instanceof VdlByte) {
            byteValue = ((VdlByte)value).getValue();
            out.write(byteValue);
        } else if (value instanceof Byte) {
            byteValue = (Byte)value;
            out.write(byteValue);
        } else {
            throw new IOException("Unsupported VDL control byte value (type " + value.getClass() + ", value " + value + ")");
        }
        return byteValue != 0;
    }

    private boolean writeVdlEnum(EncodingStream out, Object value) throws IOException {
        this.expectClass(Kind.ENUM, value, VdlEnum.class);
        int ordinal = ((VdlEnum)value).ordinal();
        BinaryUtil.encodeUint((OutputStream)out, ordinal);
        return ordinal != 0;
    }

    private boolean writeVdlFloat(EncodingStream out, Object value) throws IOException {
        if (value instanceof VdlFloat32) {
            return BinaryUtil.encodeDouble(out, ((VdlFloat32)value).getValue());
        }
        if (value instanceof VdlFloat64) {
            return BinaryUtil.encodeDouble(out, ((VdlFloat64)value).getValue());
        }
        if (value instanceof Float) {
            return BinaryUtil.encodeDouble(out, ((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return BinaryUtil.encodeDouble(out, (Double)value);
        }
        throw new IOException("Unsupported VDL float value (type " + value.getClass() + ", value " + value + ")");
    }

    private boolean writeVdlInt(EncodingStream out, Object value) throws IOException {
        if (value instanceof VdlInt8) {
            return BinaryUtil.encodeInt(out, ((VdlInt8)value).getValue());
        }
        if (value instanceof VdlInt16) {
            return BinaryUtil.encodeInt(out, ((VdlInt16)value).getValue());
        }
        if (value instanceof VdlInt32) {
            return BinaryUtil.encodeInt(out, ((VdlInt32)value).getValue());
        }
        if (value instanceof VdlInt64) {
            return BinaryUtil.encodeInt(out, ((VdlInt64)value).getValue());
        }
        if (value instanceof Short) {
            return BinaryUtil.encodeInt(out, ((Short)value).shortValue());
        }
        if (value instanceof Integer) {
            return BinaryUtil.encodeInt(out, ((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return BinaryUtil.encodeInt(out, (Long)value);
        }
        throw new IOException("Unsupported VDL int value (type " + value.getClass() + ", value " + value + ")");
    }

    private boolean writeVdlRawByte(EncodingStream out, Object value) {
        byte b;
        if (value instanceof VdlByte) {
            b = ((VdlByte)value).getValue();
        } else if (value instanceof Byte) {
            b = (Byte)value;
        } else {
            throw new RuntimeException("unknown raw byte value " + value);
        }
        out.write(b);
        return b != 0;
    }

    private boolean writeVdlBytes(EncodingStream out, Object value, VdlType type) throws IOException {
        int size;
        VdlValue collection;
        if (value.getClass().isArray()) {
            Object arrayValue = value;
            int len = Array.getLength(arrayValue);
            BinaryUtil.encodeUint((OutputStream)out, len);
            boolean nonZero = false;
            for (int i = 0; i < len; ++i) {
                nonZero = this.writeVdlRawByte(out, Array.getByte(arrayValue, i)) || nonZero;
            }
            return nonZero;
        }
        if (value instanceof VdlArray) {
            collection = (VdlArray)value;
            size = 0;
        } else if (value instanceof VdlList) {
            VdlList listValue = (VdlList)value;
            collection = listValue;
            size = listValue.size();
        } else {
            throw new IOException("Unsupported VDL list value (type " + value.getClass() + ", value " + value + ")");
        }
        BinaryUtil.encodeUint((OutputStream)out, size);
        boolean nonZero = false;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            nonZero = this.writeVdlRawByte(out, elem) || nonZero;
        }
        return nonZero;
    }

    private boolean writeVdlList(EncodingStream out, Object value, VdlType type) throws IOException {
        if (value instanceof List) {
            List listValue = (List)value;
            BinaryUtil.encodeUint((OutputStream)out, listValue.size());
            for (Object elem : listValue) {
                this.writeValue(out, elem, type.getElem());
            }
            return listValue.size() != 0;
        }
        if (value.getClass().isArray()) {
            Object arrayValue = value;
            int len = Array.getLength(arrayValue);
            BinaryUtil.encodeUint((OutputStream)out, len);
            for (int i = 0; i < len; ++i) {
                this.writeValue(out, Array.get(arrayValue, i), type.getElem());
            }
            return len != 0;
        }
        throw new IOException("Unsupported VDL list value (type " + value.getClass() + ", value " + value + ")");
    }

    private boolean writeVdlMap(EncodingStream out, Object value, VdlType type) throws IOException {
        this.expectClass(Kind.MAP, value, Map.class);
        Map mapValue = (Map)value;
        BinaryUtil.encodeUint((OutputStream)out, mapValue.size());
        for (Map.Entry entry : mapValue.entrySet()) {
            this.writeValue(out, entry.getKey(), type.getKey());
            this.writeValue(out, entry.getValue(), type.getElem());
        }
        return mapValue.size() != 0;
    }

    private boolean writeVdlUnion(EncodingStream out, Object value) throws IOException {
        this.expectClass(Kind.UNION, value, VdlUnion.class);
        VdlUnion unionValue = (VdlUnion)value;
        Object elem = unionValue.getElem();
        int index = unionValue.getIndex();
        VdlType elemType = unionValue.vdlType().getFields().get(index).getType();
        BinaryUtil.encodeUint((OutputStream)out, index);
        boolean isNonZero = index != 0;
        return isNonZero |= this.writeValue(out, elem, elemType);
    }

    private boolean writeVdlOptional(EncodingStream out, Object value) throws IOException {
        this.expectClass(Kind.OPTIONAL, value, VdlOptional.class);
        VdlOptional optionalValue = (VdlOptional)value;
        if (optionalValue.isNull()) {
            this.writeVdlControlByte(out, (byte)-32);
            return false;
        }
        this.writeValue(out, optionalValue.getElem(), optionalValue.vdlType().getElem());
        return true;
    }

    private boolean writeVdlSet(EncodingStream out, Object value, VdlType type) throws IOException {
        this.expectClass(Kind.SET, value, Set.class);
        Set setValue = (Set)value;
        BinaryUtil.encodeUint((OutputStream)out, setValue.size());
        for (Object key : setValue) {
            this.writeValue(out, key, type.getKey());
        }
        return setValue.size() != 0;
    }

    private boolean writeVdlString(EncodingStream out, Object value) throws IOException {
        String stringValue;
        if (value instanceof VdlString) {
            stringValue = ((VdlString)value).getValue();
        } else if (value instanceof String) {
            stringValue = (String)value;
        } else {
            throw new IOException("Unsupported VDL string value (type " + value.getClass() + ", value " + value + ")");
        }
        BinaryUtil.encodeBytes(out, BinaryUtil.getBytes(stringValue));
        return stringValue.length() != 0;
    }

    private boolean writeVdlStruct(EncodingStream out, Object value, VdlType type) throws IOException {
        List<VdlField> fields = type.getFields();
        boolean hasNonZeroField = false;
        for (int i = 0; i < fields.size(); ++i) {
            VdlField field = fields.get(i);
            Object fieldValue = null;
            if (value instanceof VdlStruct) {
                fieldValue = ((VdlStruct)value).getField(field.getName());
            } else {
                try {
                    Field f = value.getClass().getDeclaredField(BinaryUtil.firstCharToLower(field.getName()));
                    f.setAccessible(true);
                    fieldValue = f.get(value);
                }
                catch (Exception e) {
                    throw new IOException("Unsupported VDL struct value (type " + value.getClass() + ", value " + value + ")", e);
                }
            }
            int prevCount = out.getCount();
            int prevTypeIdCount = this.typeIds.size();
            BinaryUtil.encodeUint((OutputStream)out, i);
            if (this.writeValue(out, fieldValue, field.getType())) {
                hasNonZeroField = true;
                continue;
            }
            out.setCount(prevCount);
            while (this.typeIds.size() > prevTypeIdCount) {
                this.typeIds.remove(this.typeIds.size() - 1);
            }
        }
        this.writeVdlControlByte(out, (byte)-31);
        return hasNonZeroField;
    }

    private boolean writeVdlUint(EncodingStream out, Object value) throws IOException {
        if (value instanceof VdlByte || value instanceof Byte) {
            return this.writeVdlByte(out, value);
        }
        if (value instanceof VdlUint16) {
            return BinaryUtil.encodeUint((OutputStream)out, ((VdlUint16)value).getValue());
        }
        if (value instanceof VdlUint32) {
            return BinaryUtil.encodeUint((OutputStream)out, ((VdlUint32)value).getValue());
        }
        if (value instanceof VdlUint64) {
            return BinaryUtil.encodeUint((OutputStream)out, ((VdlUint64)value).getValue());
        }
        throw new IOException("Unsupported VDL uint value (type " + value.getClass() + ", value " + value + ")");
    }

    private boolean writeVdlTypeObject(EncodingStream out, Object object) throws IOException {
        this.expectClass(Kind.TYPEOBJECT, object, VdlTypeObject.class);
        VdlTypeObject value = (VdlTypeObject)object;
        long id = this.getType(value.getTypeObject()).getValue();
        this.writeTypeId(out, id);
        return value.getTypeObject() != Types.ANY;
    }

    private void expectClass(Kind kind, Object value, Class<?> klass) throws IOException {
        if (!klass.isAssignableFrom(value.getClass())) {
            throw new IOException("Unsupported VDL " + (Object)((Object)kind) + " value (type " + value.getClass() + ", value " + value + ")");
        }
    }
}

