/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vom;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import io.v.v23.vdl.GeneratedFromVdl;
import io.v.v23.vdl.Kind;
import io.v.v23.vdl.NativeTypes;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlStruct;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUnion;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vom.BinaryUtil;
import io.v.v23.vom.BootstrapType;
import io.v.v23.vom.Constants;
import io.v.v23.vom.ConversionException;
import io.v.v23.vom.ConversionTarget;
import io.v.v23.vom.ConvertUtil;
import io.v.v23.vom.CorruptVomStreamException;
import io.v.v23.vom.ReflectUtil;
import io.v.v23.vom.TypeCompatibility;
import io.v.v23.vom.TypeId;
import io.v.v23.vom.Version;
import io.v.v23.vom.WireArray;
import io.v.v23.vom.WireEnum;
import io.v.v23.vom.WireField;
import io.v.v23.vom.WireList;
import io.v.v23.vom.WireMap;
import io.v.v23.vom.WireNamed;
import io.v.v23.vom.WireOptional;
import io.v.v23.vom.WireSet;
import io.v.v23.vom.WireStruct;
import io.v.v23.vom.WireType;
import io.v.v23.vom.WireUnion;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BinaryDecoder {
    private final BufferedInputStream in;
    private final Map<TypeId, VdlType> decodedTypes;
    private final Map<TypeId, WireType> wireTypes;
    private boolean binaryMagicByteRead;
    private Version version;
    private long[] typeIds;
    private static Version[] allowedVersions = new Version[]{Constants.VERSION_80, Constants.VERSION_81};

    public BinaryDecoder(InputStream in) {
        this.in = new BufferedInputStream(in);
        this.decodedTypes = new HashMap<TypeId, VdlType>();
        this.wireTypes = new HashMap<TypeId, WireType>();
        this.binaryMagicByteRead = false;
    }

    private static Version versionFromByte(byte b) {
        for (Version v : allowedVersions) {
            if (v.getValue() != b) continue;
            return v;
        }
        throw new RuntimeException("invalid version byte " + b);
    }

    public Object decodeValue(Type targetType) throws IOException, ConversionException {
        if (!this.binaryMagicByteRead) {
            this.version = BinaryDecoder.versionFromByte((byte)this.in.read());
            this.binaryMagicByteRead = true;
        }
        VdlType actualType = this.decodeType();
        this.assertTypesCompatible(actualType, targetType);
        if (targetType == Object.class) {
            try {
                targetType = Types.getReflectTypeForVdl(actualType);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException(e);
            }
        }
        return this.readValueMessage(actualType, targetType);
    }

    public Object decodeValue() throws IOException, ConversionException {
        return this.decodeValue((Type)((Object)Object.class));
    }

    private void assertTypesCompatible(VdlType actualType, Type targetType) throws ConversionException {
        if (targetType != Object.class && targetType != VdlValue.class && !TypeCompatibility.compatible(actualType, Types.getVdlTypeFromReflect(targetType))) {
            throw new ConversionException((Object)actualType, targetType, "types are incompatible");
        }
    }

    private Object readValueMessage(VdlType actualType, Type targetType) throws IOException, ConversionException {
        int i;
        long len;
        if (this.version != Constants.VERSION_80 && (BinaryUtil.hasAny(actualType) || BinaryUtil.hasTypeObject(actualType))) {
            len = BinaryUtil.decodeUint(this.in);
            this.typeIds = new long[(int)len];
            i = 0;
            while ((long)i < len) {
                this.typeIds[i] = BinaryUtil.decodeUint(this.in);
                ++i;
            }
        }
        if (this.version != Constants.VERSION_80 && BinaryUtil.hasAny(actualType)) {
            len = BinaryUtil.decodeUint(this.in);
            i = 0;
            while ((long)i < len) {
                BinaryUtil.decodeUint(this.in);
                ++i;
            }
        }
        if (BinaryUtil.hasBinaryMsgLen(actualType)) {
            BinaryUtil.decodeUint(this.in);
        }
        return this.readValue(actualType, targetType);
    }

    private VdlType decodeType() throws IOException, ConversionException {
        while (true) {
            this.in.mark(1);
            int firstByte = this.in.read();
            if ((byte)firstByte != -30) {
                this.in.reset();
            }
            long typeId = BinaryUtil.decodeInt(this.in);
            if (typeId == 0L) {
                throw new CorruptVomStreamException("Unexpected zero type ID");
            }
            if (typeId > 0L) {
                return this.getType(new TypeId(typeId));
            }
            WireType wireType = (WireType)this.readValueMessage(WireType.VDL_TYPE, (Type)((Object)WireType.class));
            this.wireTypes.put(new TypeId(-typeId), wireType);
        }
    }

    private VdlType lookupType(TypeId typeId) {
        VdlType type = BootstrapType.getBootstrapType(typeId);
        if (type != null) {
            return type;
        }
        if (this.decodedTypes.containsKey(typeId)) {
            return this.decodedTypes.get(typeId);
        }
        return null;
    }

    private VdlType getType(TypeId typeId) throws CorruptVomStreamException {
        VdlType type = this.lookupType(typeId);
        if (type != null) {
            return type;
        }
        WireToVdlTypeBuilder builder = new WireToVdlTypeBuilder();
        VdlType.PendingType pendingType = builder.lookupOrBuildPending(typeId);
        builder.build();
        return pendingType.built();
    }

    private Object readValue(VdlType actualType, Type targetType) throws IOException, ConversionException {
        NativeTypes.Converter converter;
        ConversionTarget target;
        if (targetType == VdlValue.class) {
            target = new ConversionTarget(actualType);
        } else if (targetType == Object.class) {
            try {
                targetType = Types.getReflectTypeForVdl(actualType);
                target = new ConversionTarget(targetType, actualType);
            }
            catch (IllegalArgumentException e) {
                target = new ConversionTarget(actualType);
            }
        } else {
            target = new ConversionTarget(targetType);
        }
        if (actualType.getKind() != Kind.ANY && actualType.getKind() != Kind.OPTIONAL) {
            if (target.getKind() == Kind.ANY) {
                return new VdlAny(actualType, this.readValue(actualType, (Type)((Object)Object.class)));
            }
            if (target.getKind() == Kind.OPTIONAL) {
                Type elemType = ReflectUtil.getElementType(target.getTargetType(), 0);
                return VdlOptional.of((VdlValue)this.readValue(actualType, elemType));
            }
        }
        if ((converter = Types.getNativeTypeConverter(target.getTargetType())) != null) {
            VdlValue value = (VdlValue)this.readValue(actualType, converter.getWireType());
            return converter.nativeFromVdlValue(value);
        }
        switch (actualType.getKind()) {
            case ANY: {
                return this.readVdlAny(target);
            }
            case ARRAY: 
            case LIST: {
                return this.readVdlArrayOrVdlList(actualType, target);
            }
            case BOOL: {
                return this.readVdlBool(target);
            }
            case BYTE: {
                return this.readVdlByte(target);
            }
            case ENUM: {
                return this.readVdlEnum(actualType, target);
            }
            case FLOAT32: 
            case FLOAT64: {
                return this.readVdlFloat(target);
            }
            case INT8: {
                if (this.version == Constants.VERSION_80) {
                    throw new RuntimeException("int8 is unsupported in VOM version 0x80");
                }
            }
            case INT16: 
            case INT32: 
            case INT64: {
                return this.readVdlInt(target);
            }
            case MAP: 
            case SET: {
                return this.readVdlMapOrSet(actualType, target);
            }
            case STRUCT: {
                return this.readVdlStruct(actualType, target);
            }
            case UNION: {
                return this.readVdlUnion(actualType, target);
            }
            case OPTIONAL: {
                return this.readVdlOptional(actualType, target);
            }
            case STRING: {
                return this.readVdlString(target);
            }
            case TYPEOBJECT: {
                return this.readVdlTypeObject();
            }
            case UINT16: 
            case UINT32: 
            case UINT64: {
                return this.readVdlUint(target);
            }
        }
        throw new ConversionException(actualType, targetType);
    }

    private Object createNullValue(ConversionTarget target) throws ConversionException {
        if (target.getKind() == Kind.ANY) {
            return new VdlAny();
        }
        if (target.getKind() == Kind.OPTIONAL) {
            return new VdlOptional(target.getVdlType());
        }
        throw new ConversionException("Can't create a null value of " + target.getTargetType());
    }

    private Object readVdlAny(ConversionTarget target) throws IOException, ConversionException {
        long typeId;
        if (this.peekFlag() == -32) {
            ByteStreams.skipFully((InputStream)this.in, (long)1L);
            return this.createNullValue(target);
        }
        if (this.version == Constants.VERSION_80) {
            typeId = BinaryUtil.decodeUint(this.in);
        } else {
            typeId = this.typeIds[(int)BinaryUtil.decodeUint(this.in)];
            BinaryUtil.decodeUint(this.in);
        }
        VdlType actualType = this.getType(new TypeId(typeId));
        if (target.getKind() == Kind.ANY) {
            return new VdlAny(actualType, this.readValue(actualType, (Type)((Object)Object.class)));
        }
        Type targetType = target.getTargetType();
        this.assertTypesCompatible(actualType, targetType);
        return this.readValue(actualType, targetType);
    }

    private Object readVdlBytes(int len, ConversionTarget target) throws IOException, ConversionException {
        int numRead;
        int result;
        byte[] buf = new byte[len];
        for (numRead = 0; numRead < len; numRead += result) {
            result = this.in.read(buf, numRead, buf.length - numRead);
            if (result != -1) continue;
            throw new CorruptVomStreamException("stream ended before full vdl bytes received");
        }
        if (numRead > len) {
            throw new RuntimeException("too many bytes returned from read()");
        }
        return ConvertUtil.convertFromBytes(buf, target);
    }

    private Object readVdlArrayOrVdlList(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        int len;
        if (actualType.getKind() == Kind.LIST) {
            len = (int)BinaryUtil.decodeUint(this.in);
        } else {
            long uint = BinaryUtil.decodeUint(this.in);
            if (uint != 0L) {
                throw new CorruptVomStreamException("Array length should be encoded as 0, but it is " + uint);
            }
            len = actualType.getLength();
        }
        if (actualType.getElem().getKind() == Kind.BYTE) {
            return this.readVdlBytes(len, target);
        }
        Class<?> targetClass = target.getTargetClass();
        if (!List.class.isAssignableFrom(targetClass)) {
            if (BinaryUtil.isBytes(actualType) && targetClass.equals(byte[].class)) {
                return BinaryUtil.decodeBytes(this.in, len);
            }
            if (!targetClass.isArray()) {
                return ConvertUtil.convertFromBytes(BinaryUtil.decodeBytes(this.in, len), target);
            }
        }
        Type elementType = ReflectUtil.getElementType(target.getTargetType(), 0);
        if (targetClass.isArray() || VdlArray.class.isAssignableFrom(targetClass)) {
            int targetLen = len;
            if (target.getKind() == Kind.ARRAY) {
                if (len > target.getVdlType().getLength()) {
                    throw new ConversionException((Object)actualType, target.getTargetType(), "target array is too short");
                }
                targetLen = target.getVdlType().getLength();
            }
            Class<?> elementClass = ReflectUtil.getRawClass(elementType);
            Object array = Array.newInstance(elementClass, targetLen);
            for (int i = 0; i < len; ++i) {
                ReflectUtil.setArrayValue(array, i, this.readValue(actualType.getElem(), elementType), elementClass);
            }
            return ReflectUtil.createGeneric(target, array);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < len; ++i) {
            list.add(this.readValue(actualType.getElem(), elementType));
        }
        return ReflectUtil.createGeneric(target, list);
    }

    private Object readVdlBool(ConversionTarget target) throws IOException, ConversionException {
        byte b = this.version == Constants.VERSION_80 ? BinaryUtil.decodeBytes(this.in, 1)[0] : (byte)BinaryUtil.decodeUint(this.in);
        return ReflectUtil.createPrimitive(target, b != 0, Boolean.TYPE);
    }

    private Object readVdlByte(ConversionTarget target) throws IOException, ConversionException {
        byte b = this.version == Constants.VERSION_80 ? BinaryUtil.decodeBytes(this.in, 1)[0] : (byte)BinaryUtil.decodeUint(this.in);
        return ConvertUtil.convertFromByte(b, target);
    }

    private Object readVdlEnum(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        int enumIndex = (int)BinaryUtil.decodeUint(this.in);
        byte[] bytes = actualType.getLabels().get(enumIndex).getBytes(BinaryUtil.UTF8_CHARSET);
        return ConvertUtil.convertFromBytes(bytes, target);
    }

    private Object readVdlFloat(ConversionTarget target) throws IOException, ConversionException {
        return ConvertUtil.convertFromDouble(BinaryUtil.decodeDouble(this.in), target);
    }

    private Object readVdlInt(ConversionTarget target) throws IOException, ConversionException {
        return ConvertUtil.convertFromInt(BinaryUtil.decodeInt(this.in), target);
    }

    private Type getMapElemOrStructFieldType(ConversionTarget target, Object key) throws ConversionException {
        Class<?> targetClass = target.getTargetClass();
        if (target.getKind() == Kind.MAP) {
            return ReflectUtil.getElementType(target.getTargetType(), 1);
        }
        if (target.getKind() == Kind.SET) {
            return Boolean.class;
        }
        if (targetClass == VdlStruct.class) {
            return VdlValue.class;
        }
        String fieldName = (String)key;
        try {
            Field field = targetClass.getDeclaredField(BinaryUtil.firstCharToLower(fieldName));
            return field.getGenericType();
        }
        catch (NoSuchFieldException noSuchFieldException) {
            for (Field field : targetClass.getDeclaredFields()) {
                GeneratedFromVdl annotation = field.getAnnotation(GeneratedFromVdl.class);
                if (annotation == null || !annotation.name().equals(fieldName)) continue;
                return field.getGenericType();
            }
            return Object.class;
        }
    }

    private void setMapElemOrStructField(ConversionTarget target, Object data, Object key, Object elem, Type elemType) throws ConversionException {
        if (target.getKind() == Kind.MAP) {
            ((Map)data).put(key, elem);
        } else if (target.getKind() == Kind.SET) {
            if (((Boolean)elem).booleanValue()) {
                ((Set)data).add(key);
            }
        } else if (data instanceof VdlStruct) {
            ((VdlStruct)data).assignField((String)key, (VdlValue)elem);
        } else {
            if (elemType == Object.class) {
                return;
            }
            try {
                Field f = data.getClass().getDeclaredField(BinaryUtil.firstCharToLower((String)key));
                f.setAccessible(true);
                f.set(data, elem);
            }
            catch (Exception e) {
                throw new ConversionException("Can't set field " + key + " to " + elem + " of " + target.getTargetType(), e);
            }
        }
    }

    private Object createMapOrSetOrStruct(ConversionTarget target) throws ConversionException {
        if (target.getKind() == Kind.MAP) {
            return ReflectUtil.createGeneric(target, new HashMap());
        }
        if (target.getKind() == Kind.SET) {
            return ReflectUtil.createGeneric(target, new HashSet());
        }
        return ReflectUtil.createStruct(target);
    }

    private Type getTargetKeyType(ConversionTarget target) throws ConversionException {
        if (target.getKind() == Kind.MAP || target.getKind() == Kind.SET) {
            return ReflectUtil.getElementType(target.getTargetType(), 0);
        }
        return String.class;
    }

    private Object readVdlMapOrSet(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        Object data = this.createMapOrSetOrStruct(target);
        Type targetKeyType = this.getTargetKeyType(target);
        int len = (int)BinaryUtil.decodeUint(this.in);
        for (int i = 0; i < len; ++i) {
            Object key = this.readValue(actualType.getKey(), targetKeyType);
            Type targetElemType = this.getMapElemOrStructFieldType(target, key);
            Object elem = actualType.getKind() == Kind.SET ? (targetElemType == VdlAny.class ? new VdlAny((Type)((Object)Boolean.class), (Object)true) : ReflectUtil.createPrimitive(new ConversionTarget(targetElemType), true, Boolean.TYPE)) : this.readValue(actualType.getElem(), targetElemType);
            this.setMapElemOrStructField(target, data, key, elem, targetElemType);
        }
        return data;
    }

    private Object readVdlStruct(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        Object key;
        VdlField field;
        Object data = this.createMapOrSetOrStruct(target);
        Type targetKeyType = this.getTargetKeyType(target);
        boolean[] seen = new boolean[actualType.getFields().size()];
        Arrays.fill(seen, false);
        while (true) {
            if (this.peekFlag() == -31) break;
            int index = (int)BinaryUtil.decodeUint(this.in);
            seen[index] = true;
            field = actualType.getFields().get(index);
            Type targetElemType = this.getMapElemOrStructFieldType(target, field.getName());
            key = ConvertUtil.convertFromBytes(BinaryUtil.getBytes(field.getName()), new ConversionTarget(targetKeyType));
            Object elem = this.readValue(field.getType(), targetElemType);
            this.setMapElemOrStructField(target, data, key, elem, targetElemType);
        }
        ByteStreams.skipFully((InputStream)this.in, (long)1L);
        if (target.getKind() != Kind.MAP) {
            return data;
        }
        for (int i = 0; i < actualType.getFields().size(); ++i) {
            VdlValue elem;
            if (seen[i]) continue;
            field = actualType.getFields().get(i);
            Type elemType = this.getMapElemOrStructFieldType(target, field.getName());
            key = ConvertUtil.convertFromBytes(BinaryUtil.getBytes(field.getName()), new ConversionTarget(targetKeyType));
            VdlType elemVdlType = target.getVdlType().getElem();
            if (elemType instanceof Class && ((Class)elemType).getSuperclass() != VdlValue.class) {
                try {
                    elem = ((Class)elemType).newInstance();
                }
                catch (Exception e) {
                    throw new ConversionException(field.getType(), elemType);
                }
            } else {
                elem = VdlValue.zeroValue(elemVdlType);
            }
            this.setMapElemOrStructField(target, data, key, elem, elemType);
        }
        return data;
    }

    private Object readVdlUnion(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        int index = (int)BinaryUtil.decodeUint(this.in);
        if (index < 0 || index >= actualType.getFields().size()) {
            throw new CorruptVomStreamException("Union index " + index + " is out of range " + 1 + "..." + actualType.getFields().size());
        }
        VdlField actualField = actualType.getFields().get(index);
        VdlType actualElemType = actualField.getType();
        if (target.getTargetClass() == VdlUnion.class) {
            return new VdlUnion(actualType, index, actualElemType, this.readValue(actualElemType, (Type)((Object)Object.class)));
        }
        Class<?> targetClass = target.getTargetClass();
        if (targetClass.getSuperclass() != VdlUnion.class) {
            targetClass = targetClass.getSuperclass();
        }
        Class<?> fieldClass = null;
        for (Class<?> klass : targetClass.getDeclaredClasses()) {
            if (!klass.getName().equals(targetClass.getName() + "$" + actualField.getName())) continue;
            fieldClass = klass;
            break;
        }
        if (fieldClass == null) {
            throw new ConversionException(actualType, target.getTargetType());
        }
        try {
            Type elemType = fieldClass.getDeclaredField("elem").getGenericType();
            return fieldClass.getConstructor(ReflectUtil.getRawClass(elemType)).newInstance(this.readValue(actualElemType, elemType));
        }
        catch (Exception e) {
            throw new ConversionException((Object)actualType, target.getTargetType(), e);
        }
    }

    private Object readVdlOptional(VdlType actualType, ConversionTarget target) throws IOException, ConversionException {
        if (this.peekFlag() == -32) {
            ByteStreams.skipFully((InputStream)this.in, (long)1L);
            return this.createNullValue(target);
        }
        Type type = target.getTargetType();
        if (target.getKind() == Kind.OPTIONAL) {
            type = ReflectUtil.getElementType(type, 0);
            Object elem = this.readValue(actualType.getElem(), type);
            if (elem instanceof VdlValue) {
                return VdlOptional.of((VdlValue)elem);
            }
            return elem;
        }
        return this.readValue(actualType.getElem(), type);
    }

    private Object readVdlString(ConversionTarget target) throws IOException, ConversionException {
        int len = (int)BinaryUtil.decodeUint(this.in);
        byte[] bytes = BinaryUtil.decodeBytes(this.in, len);
        return ConvertUtil.convertFromBytes(bytes, target);
    }

    private Object readVdlUint(ConversionTarget target) throws IOException, ConversionException {
        return ConvertUtil.convertFromUint(BinaryUtil.decodeUint(this.in), target);
    }

    private Object readVdlTypeObject() throws IOException {
        long typeId = this.version == Constants.VERSION_80 ? BinaryUtil.decodeUint(this.in) : this.typeIds[(int)BinaryUtil.decodeUint(this.in)];
        return new VdlTypeObject(this.getType(new TypeId(typeId)));
    }

    private byte peekFlag() throws IOException {
        this.in.mark(1);
        byte flag = (byte)this.in.read();
        this.in.reset();
        return flag;
    }

    private final class WireToVdlTypeBuilder {
        private final VdlType.Builder builder = new VdlType.Builder();
        private final Map<TypeId, VdlType.PendingType> pendingTypes = new HashMap<TypeId, VdlType.PendingType>();

        public void build() {
            this.builder.build();
            for (Map.Entry<TypeId, VdlType.PendingType> entry : this.pendingTypes.entrySet()) {
                VdlType vdlType = entry.getValue().built();
                if (!Strings.isNullOrEmpty((String)vdlType.getName())) {
                    Types.loadClassForVdlName(vdlType.getName());
                }
                BinaryDecoder.this.decodedTypes.put(entry.getKey(), vdlType);
            }
        }

        public VdlType.PendingType lookupOrBuildPending(TypeId typeId) throws CorruptVomStreamException {
            VdlType.PendingType vdlType = this.lookupType(typeId);
            if (vdlType != null) {
                return vdlType;
            }
            return this.buildPendingType(typeId);
        }

        private VdlType.PendingType lookupType(TypeId typeId) {
            VdlType type = BinaryDecoder.this.lookupType(typeId);
            if (type != null) {
                return this.builder.builtPendingFromType(type);
            }
            if (this.pendingTypes.containsKey(typeId)) {
                return this.pendingTypes.get(typeId);
            }
            return null;
        }

        private VdlType.PendingType buildPendingType(TypeId typeId) throws CorruptVomStreamException {
            WireType wireType = (WireType)BinaryDecoder.this.wireTypes.get(typeId);
            if (wireType == null) {
                throw new CorruptVomStreamException("Unknown wire type " + typeId);
            }
            VdlType.PendingType pending = this.builder.newPending();
            this.pendingTypes.put(typeId, pending);
            switch (wireType.getIndex()) {
                case 0: {
                    WireNamed wireNamed = (WireNamed)wireType.getElem();
                    return pending.setName(wireNamed.getName()).assignBase(this.lookupOrBuildPending(wireNamed.getBase()));
                }
                case 1: {
                    WireEnum wireEnum = (WireEnum)wireType.getElem();
                    pending.setName(wireEnum.getName()).setKind(Kind.ENUM);
                    for (String label : wireEnum.getLabels()) {
                        pending.addLabel(label);
                    }
                    return pending;
                }
                case 2: {
                    WireArray wireArray = (WireArray)wireType.getElem();
                    return pending.setName(wireArray.getName()).setKind(Kind.ARRAY).setLength((int)wireArray.getLen().getValue()).setElem(this.lookupOrBuildPending(wireArray.getElem()));
                }
                case 3: {
                    WireList wireList = (WireList)wireType.getElem();
                    return pending.setName(wireList.getName()).setKind(Kind.LIST).setElem(this.lookupOrBuildPending(wireList.getElem()));
                }
                case 4: {
                    WireSet wireSet = (WireSet)wireType.getElem();
                    return pending.setName(wireSet.getName()).setKind(Kind.SET).setKey(this.lookupOrBuildPending(wireSet.getKey()));
                }
                case 5: {
                    WireMap wireMap = (WireMap)wireType.getElem();
                    return pending.setName(wireMap.getName()).setKind(Kind.MAP).setKey(this.lookupOrBuildPending(wireMap.getKey())).setElem(this.lookupOrBuildPending(wireMap.getElem()));
                }
                case 6: {
                    WireStruct wireStruct = (WireStruct)wireType.getElem();
                    pending.setName(wireStruct.getName()).setKind(Kind.STRUCT);
                    for (WireField field : wireStruct.getFields()) {
                        pending.addField(field.getName(), this.lookupOrBuildPending(field.getType()));
                    }
                    return pending;
                }
                case 7: {
                    WireUnion wireUnion = (WireUnion)wireType.getElem();
                    pending.setName(wireUnion.getName()).setKind(Kind.UNION);
                    for (WireField field : wireUnion.getFields()) {
                        pending.addField(field.getName(), this.lookupOrBuildPending(field.getType()));
                    }
                    return pending;
                }
                case 8: {
                    WireOptional wireOptional = (WireOptional)wireType.getElem();
                    return pending.setName(wireOptional.getName()).setKind(Kind.OPTIONAL).setElem(this.lookupOrBuildPending(wireOptional.getElem()));
                }
            }
            throw new CorruptVomStreamException("Unknown wire type: " + wireType.vdlType());
        }
    }
}

