/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.verror;

import io.v.v23.context.VContext;
import io.v.v23.i18n.Language;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlType;
import io.v.v23.verror.UnknownException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class VException
extends Exception {
    private static final long serialVersionUID = 1L;
    private static VContext defaultContext = null;
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final IDAction id;
    private final Object[] params;
    private final VdlType[] paramTypes;

    public static IDAction register(String id, ActionCode action, String englishText) {
        Language.getDefaultCatalog().setWithBase("en-US", id, englishText);
        return new IDAction(id, action);
    }

    public static void setDefaultContext(VContext ctx) {
        lock.writeLock().lock();
        defaultContext = ctx;
        lock.writeLock().unlock();
    }

    public static VContext contextWithComponentName(VContext base, String componentName) {
        return base.withValue(new ComponentNameKey(), componentName);
    }

    private static VException create(IDAction idAction, String language, String componentName, String opName, Object[] params, VdlType[] paramTypes) {
        if (params == null) {
            params = new Object[]{};
        }
        if (paramTypes == null) {
            paramTypes = new VdlType[]{};
        }
        if (params.length != paramTypes.length) {
            System.err.println(String.format("Passed different number of types (%s) than parameters (%s) to VException. Some params may be dropped.", Arrays.toString(paramTypes), Arrays.toString(params)));
            int length = params.length <= paramTypes.length ? params.length : paramTypes.length;
            params = Arrays.copyOf(params, length);
            paramTypes = Arrays.copyOf(paramTypes, length);
        }
        ArrayList<Object> newParams = new ArrayList<Object>(params.length + 2);
        ArrayList<VdlType> newParamTypes = new ArrayList<VdlType>(paramTypes.length + 2);
        for (int i = 0; i < params.length; ++i) {
            if (!(params[i] instanceof Serializable)) {
                System.err.println(String.format("Dropping parameter #%d (%s) that isn't serializable", i, params[i]));
                continue;
            }
            if (paramTypes[i] == null) {
                System.err.println(String.format("Dropping parameter #%d (%s) whose type doesn't have a matching VdlType.", i, params[i]));
                continue;
            }
            newParams.add((Serializable)params[i]);
            newParamTypes.add(paramTypes[i]);
        }
        newParams.add(0, componentName);
        newParamTypes.add(0, Types.STRING);
        newParams.add(1, opName);
        newParamTypes.add(1, Types.STRING);
        String msg = Language.getDefaultCatalog().format(language, idAction.getID(), newParams.toArray());
        return new VException(idAction, msg, (Object[])newParams.toArray(new Serializable[newParams.size()]), newParamTypes.toArray(new VdlType[newParamTypes.size()]));
    }

    private static String componentNameFromContext(VContext ctx) {
        Object value;
        if (ctx == null) {
            lock.readLock().lock();
            ctx = defaultContext;
            lock.readLock().unlock();
        }
        String componentName = "";
        if (ctx != null && (value = ctx.value(new ComponentNameKey())) != null && value instanceof String) {
            componentName = (String)value;
        }
        if (componentName.isEmpty()) {
            componentName = System.getProperty("program.name", "");
        }
        if (componentName.isEmpty()) {
            componentName = System.getProperty("user.name", "");
        }
        return componentName;
    }

    private static String languageFromContext(VContext ctx) {
        if (ctx == null) {
            lock.readLock().lock();
            ctx = defaultContext;
            lock.readLock().unlock();
        }
        String language = "";
        if (ctx != null) {
            language = Language.languageFromContext(ctx);
        }
        if (language.isEmpty()) {
            language = "en-US";
        }
        return language;
    }

    private static Type[] createParamTypes(Object[] params) {
        Type[] ret = new Type[params.length];
        for (int i = 0; i < params.length; ++i) {
            ret[i] = params[i] == null ? String.class : params[i].getClass();
        }
        return ret;
    }

    private static VdlType[] convertParamTypes(Type[] types) {
        if (types == null) {
            return null;
        }
        VdlType[] vdlTypes = new VdlType[types.length];
        for (int i = 0; i < types.length; ++i) {
            try {
                vdlTypes[i] = Types.getVdlTypeFromReflect(types[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.format("Couldn't determine VDL type for param reflect type %s.  This param will be dropped if ever VOM-encoded", types[i]));
                vdlTypes[i] = null;
            }
        }
        return vdlTypes;
    }

    public VException(String msg) {
        this(UnknownException.ID_ACTION, (VContext)null, msg);
    }

    public VException(IDAction idAction, VContext ctx, Object ... params) {
        this(idAction, ctx, params, VException.createParamTypes(params));
    }

    public VException(IDAction idAction, VContext ctx, Object[] params, Type[] paramTypes) {
        this(idAction, VException.languageFromContext(ctx), VException.componentNameFromContext(ctx), "", params, paramTypes);
    }

    public VException(IDAction idAction, String language, String componentName, String opName, Object ... params) {
        this(idAction, language, componentName, opName, params, VException.createParamTypes(params));
    }

    public VException(IDAction idAction, String language, String componentName, String opName, Object[] params, Type[] paramTypes) {
        this(VException.create(idAction, language, componentName, opName, params, VException.convertParamTypes(paramTypes)));
    }

    VException(IDAction id, String msg, Object[] params, VdlType[] paramTypes) {
        super(msg);
        this.id = id;
        this.params = params;
        this.paramTypes = paramTypes;
    }

    protected VException(VException other) {
        this(other.id, other.getMessage(), other.params, other.paramTypes);
    }

    public String getID() {
        return this.id.getID();
    }

    public ActionCode getAction() {
        return this.id.getAction();
    }

    public boolean is(String id) {
        return this.getID().equals(id);
    }

    public boolean is(IDAction idAction) {
        return this.is(idAction.getID());
    }

    public boolean deepEquals(Object obj) {
        if (!this.equals(obj)) {
            return false;
        }
        VException other = (VException)obj;
        if (!this.getAction().equals((Object)other.getAction())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getParams(), other.getParams())) {
            return false;
        }
        return Arrays.equals(this.getParamTypes(), other.getParamTypes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VException)) {
            return false;
        }
        VException other = (VException)obj;
        return this.getID().equals(other.getID());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    Object[] getParams() {
        return this.params;
    }

    VdlType[] getParamTypes() {
        return this.paramTypes;
    }

    private static class ComponentNameKey {
        private ComponentNameKey() {
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class IDAction {
        private final String id;
        private final ActionCode action;

        public IDAction(String id, ActionCode action) {
            this.id = id == null ? "" : id;
            this.action = action;
        }

        public String getID() {
            return this.id;
        }

        public ActionCode getAction() {
            return this.action;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IDAction other = (IDAction)obj;
            if (!this.id.equals(other.id)) {
                return false;
            }
            return this.action == other.action;
        }

        public int hashCode() {
            int result = 1;
            int prime = 31;
            result = prime * result + this.id.hashCode();
            result = prime * result + this.action.hashCode();
            return result;
        }

        public String toString() {
            return String.format("{ID: %s, Action: %s}", new Object[]{this.id, this.action});
        }
    }

    public static enum ActionCode {
        NO_RETRY(0),
        RETRY_CONNECTION(1),
        RETRY_REFETCH(2),
        RETRY_BACKOFF(3);

        private final int value;

        public static ActionCode fromValue(int value) {
            switch (value) {
                case 0: {
                    return NO_RETRY;
                }
                case 1: {
                    return RETRY_CONNECTION;
                }
                case 2: {
                    return RETRY_REFETCH;
                }
                case 3: {
                    return RETRY_BACKOFF;
                }
            }
            return NO_RETRY;
        }

        private ActionCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

