/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlBool;
import io.v.v23.vdl.VdlByte;
import io.v.v23.vdl.VdlEnum;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlFloat32;
import io.v.v23.vdl.VdlFloat64;
import io.v.v23.vdl.VdlInt16;
import io.v.v23.vdl.VdlInt32;
import io.v.v23.vdl.VdlInt64;
import io.v.v23.vdl.VdlList;
import io.v.v23.vdl.VdlMap;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlSet;
import io.v.v23.vdl.VdlString;
import io.v.v23.vdl.VdlStruct;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint16;
import io.v.v23.vdl.VdlUint32;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlUnion;
import io.v.v23.vom.BinaryDecoder;
import io.v.v23.vom.BinaryEncoder;
import io.v.v23.vom.ConversionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public abstract class VdlValue
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final VdlType type;

    protected VdlValue(VdlType type) {
        this.type = type;
    }

    protected void assertKind(Kind kind) {
        if (this.type.getKind() != kind) {
            throw new IllegalArgumentException("Kind of VDL type should be " + (Object)((Object)kind));
        }
    }

    public VdlType vdlType() {
        return this.type;
    }

    public static VdlValue valueOf(Object value, VdlType type) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BinaryEncoder encoder = new BinaryEncoder(out);
            encoder.encodeValue(type, value);
            BinaryDecoder decoder = new BinaryDecoder(new ByteArrayInputStream(out.toByteArray()));
            return (VdlValue)decoder.decodeValue((Type)((Object)VdlValue.class));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("IO error while converting value %s of type %s into VdlValue", value, type), e);
        }
        catch (ConversionException e) {
            throw new IllegalArgumentException(String.format("Couldn't convert value %s of type %s into VdlValue", value, type), e);
        }
    }

    public static VdlValue valueOf(Object value, Type type) {
        return VdlValue.valueOf(value, Types.getVdlTypeFromReflect(type));
    }

    public static VdlValue zeroValue(VdlType type) {
        if (type == null) {
            throw new IllegalArgumentException("Trying to construct a zero value using null type");
        }
        switch (type.getKind()) {
            case ANY: {
                return new VdlAny();
            }
            case ARRAY: {
                VdlValue[] backingArray = new VdlValue[type.getLength()];
                VdlValue elemValue = VdlValue.zeroValue(type.getElem());
                for (int i = 0; i < type.getLength(); ++i) {
                    backingArray[i] = elemValue;
                }
                return new VdlArray<VdlValue>(type, backingArray);
            }
            case BOOL: {
                return new VdlBool();
            }
            case BYTE: {
                return new VdlByte();
            }
            case ENUM: {
                return new VdlEnum(type, type.getLabels().get(0));
            }
            case FLOAT32: {
                return new VdlFloat32();
            }
            case FLOAT64: {
                return new VdlFloat64();
            }
            case INT16: {
                return new VdlInt16();
            }
            case INT32: {
                return new VdlInt32();
            }
            case INT64: {
                return new VdlInt64();
            }
            case LIST: {
                return new VdlList(type, new ArrayList());
            }
            case MAP: {
                return new VdlMap(type, new HashMap());
            }
            case UNION: {
                VdlField zeroField = type.getFields().get(0);
                return new VdlUnion(type, 0, zeroField.getType(), VdlValue.zeroValue(zeroField.getType()));
            }
            case OPTIONAL: {
                return new VdlOptional(type);
            }
            case SET: {
                return new VdlSet(type, new HashSet());
            }
            case STRING: {
                return new VdlString();
            }
            case STRUCT: {
                VdlStruct struct = new VdlStruct(type);
                for (VdlField field : type.getFields()) {
                    struct.assignField(field.getName(), VdlValue.zeroValue(field.getType()));
                }
                return struct;
            }
            case TYPEOBJECT: {
                return new VdlTypeObject(Types.ANY);
            }
            case UINT16: {
                return new VdlUint16();
            }
            case UINT32: {
                return new VdlUint32();
            }
            case UINT64: {
                return new VdlUint64();
            }
        }
        throw new IllegalArgumentException("Unhandled kind " + (Object)((Object)type.getKind()));
    }

    public static VdlValue nonNullZeroValue(VdlType type) {
        if (type == null) {
            throw new IllegalArgumentException("Trying to construct a non-null zero value using null type");
        }
        switch (type.getKind()) {
            case ANY: {
                throw new IllegalArgumentException("Type ANY doesn't have a non-null zero value");
            }
            case OPTIONAL: {
                return VdlOptional.of(VdlValue.zeroValue(type.getElem()));
            }
        }
        return VdlValue.zeroValue(type);
    }
}

