/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;

public class VdlUnion
extends VdlValue {
    private static final long serialVersionUID = 1L;
    private Object elem;
    private int index;

    protected VdlUnion(VdlType type, int index, Object elem) {
        super(type);
        this.assertKind(Kind.UNION);
        if (index < 0 || index > type.getFields().size()) {
            throw new IndexOutOfBoundsException("Union index " + index + " is out of range " + 0 + "..." + (type.getFields().size() - 1));
        }
        this.index = index;
        this.elem = elem;
    }

    public VdlUnion(VdlType type, int index, VdlType elemType, Object elem) {
        this(type, index, elem);
        if (!this.vdlType().getFields().get(index).getType().equals(elemType)) {
            throw new IllegalArgumentException("Illegal type " + elemType + " of elem: it should" + "be " + this.vdlType().getFields().get(index).getType());
        }
    }

    public Object getElem() {
        return this.elem;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.vdlType().getFields().get(this.index).getName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VdlUnion)) {
            return false;
        }
        VdlUnion other = (VdlUnion)obj;
        return this.getElem().equals(other.getElem());
    }

    public int hashCode() {
        return this.elem == null ? 0 : this.elem.hashCode();
    }

    public String toString() {
        return this.elem.toString();
    }
}

