/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlField;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class VdlType
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Kind kind;
    private String name;
    private ImmutableList<String> labels;
    private int length;
    private VdlType key;
    private VdlType elem;
    private ImmutableList<VdlField> fields;
    private String typeString;
    private static final Map<String, VdlType> uniqueTypes = new ConcurrentHashMap<String, VdlType>();

    private static String typeString(VdlType type, Map<String, VdlType> seen) {
        if (!Strings.isNullOrEmpty((String)type.name)) {
            VdlType seenType = seen.get(type.name);
            if (seenType != null) {
                if (seenType != type) {
                    throw new IllegalArgumentException("Duplicate type name " + type.name);
                }
                return type.name;
            }
            seen.put(type.name, type);
        }
        String result = "";
        if (!Strings.isNullOrEmpty((String)type.name)) {
            result = type.name + " ";
        }
        switch (type.kind) {
            case ENUM: {
                return result + "enum{" + Joiner.on((String)";").join(type.labels) + "}";
            }
            case ARRAY: {
                return result + "[" + type.length + "]" + VdlType.typeString(type.elem, seen);
            }
            case LIST: {
                return result + "[]" + VdlType.typeString(type.elem, seen);
            }
            case SET: {
                return result + "set[" + VdlType.typeString(type.key, seen) + "]";
            }
            case MAP: {
                return result + "map[" + VdlType.typeString(type.key, seen) + "]" + VdlType.typeString(type.elem, seen);
            }
            case STRUCT: 
            case UNION: {
                result = type.kind == Kind.STRUCT ? result + "struct{" : result + "union{";
                for (int i = 0; i < type.fields.size(); ++i) {
                    if (i > 0) {
                        result = result + ";";
                    }
                    VdlField field = (VdlField)type.fields.get(i);
                    result = result + field.getName() + " " + VdlType.typeString(field.getType(), seen);
                }
                return result + "}";
            }
            case OPTIONAL: {
                return result + "?" + VdlType.typeString(type.elem, seen);
            }
        }
        return result + type.kind.name().toLowerCase();
    }

    private Object readResolve() {
        return VdlType.getUniqueType(this);
    }

    private static synchronized VdlType getUniqueType(VdlType type) {
        VdlType uniqueType;
        if (type == null) {
            return null;
        }
        if (type.typeString == null) {
            type.typeString = VdlType.typeString(type, new HashMap<String, VdlType>());
        }
        if ((uniqueType = uniqueTypes.get(type.typeString)) != null) {
            return uniqueType;
        }
        uniqueTypes.put(type.typeString, type);
        type.key = VdlType.getUniqueType(type.key);
        type.elem = VdlType.getUniqueType(type.elem);
        if (type.fields != null) {
            ImmutableList.Builder builder = new ImmutableList.Builder();
            for (VdlField field : type.fields) {
                builder.add((Object)new VdlField(field.getName(), VdlType.getUniqueType(field.getType())));
            }
            type.fields = builder.build();
        }
        return type;
    }

    private VdlType() {
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public int getLength() {
        return this.length;
    }

    public VdlType getKey() {
        return this.key;
    }

    public VdlType getElem() {
        return this.elem;
    }

    public List<VdlField> getFields() {
        return this.fields;
    }

    public String toString() {
        return this.typeString;
    }

    public static final class PendingType {
        private VdlType vdlType;
        private final List<String> labels;
        private final List<VdlField> fields;
        private boolean built;

        private PendingType(VdlType vdlType) {
            this.vdlType = vdlType;
            this.labels = null;
            this.fields = null;
            this.built = true;
        }

        private PendingType() {
            this.vdlType = new VdlType();
            this.labels = new ArrayList<String>();
            this.fields = new ArrayList<VdlField>();
            this.built = false;
        }

        private void prepare() {
            if (this.built) {
                return;
            }
            switch (this.vdlType.kind) {
                case ENUM: {
                    this.vdlType.labels = ImmutableList.copyOf(this.labels);
                    break;
                }
                case STRUCT: 
                case UNION: {
                    this.vdlType.fields = ImmutableList.copyOf(this.fields);
                    break;
                }
            }
        }

        private void build() {
            if (this.built) {
                return;
            }
            this.vdlType = VdlType.getUniqueType(this.vdlType);
            this.built = true;
        }

        public PendingType setKind(Kind kind) {
            this.assertNotBuilt();
            this.vdlType.kind = kind;
            return this;
        }

        public PendingType setName(String name) {
            this.assertNotBuilt();
            this.vdlType.name = name;
            return this;
        }

        public PendingType addLabel(String label) {
            this.assertNotBuilt();
            this.assertOneOfKind(Kind.ENUM);
            this.labels.add(label);
            return this;
        }

        public PendingType setLength(int length) {
            this.assertNotBuilt();
            this.assertOneOfKind(Kind.ARRAY);
            this.vdlType.length = length;
            return this;
        }

        public PendingType setKey(VdlType key) {
            this.assertNotBuilt();
            this.assertOneOfKind(Kind.SET, Kind.MAP);
            this.vdlType.key = key;
            return this;
        }

        public PendingType setKey(PendingType key) {
            return this.setKey(key.vdlType);
        }

        public PendingType setElem(VdlType elem) {
            this.assertNotBuilt();
            this.assertOneOfKind(Kind.ARRAY, Kind.LIST, Kind.MAP, Kind.OPTIONAL);
            this.vdlType.elem = elem;
            return this;
        }

        public PendingType setElem(PendingType elem) {
            return this.setElem(elem.vdlType);
        }

        public PendingType addField(String name, VdlType type) {
            this.assertNotBuilt();
            this.assertOneOfKind(Kind.STRUCT, Kind.UNION);
            this.fields.add(new VdlField(name, type));
            return this;
        }

        public PendingType addField(String name, PendingType type) {
            return this.addField(name, type.vdlType);
        }

        public PendingType assignBase(VdlType type) {
            this.assertNotBuilt();
            this.vdlType.kind = type.kind;
            this.vdlType.length = type.length;
            this.vdlType.key = type.key;
            this.vdlType.elem = type.elem;
            this.labels.clear();
            if (type.labels != null) {
                this.labels.addAll((Collection<String>)type.labels);
            }
            this.fields.clear();
            if (type.fields != null) {
                this.fields.addAll((Collection<VdlField>)type.fields);
            }
            return this;
        }

        public PendingType assignBase(PendingType pending) {
            return this.assignBase(pending.vdlType);
        }

        public VdlType built() {
            if (!this.built) {
                throw new IllegalStateException("The pending type is not built yet");
            }
            return this.vdlType;
        }

        private void assertNotBuilt() {
            if (this.built) {
                throw new IllegalStateException("The pending type is already built");
            }
        }

        private void assertOneOfKind(Kind ... kinds) {
            for (Kind kind : kinds) {
                if (this.vdlType.kind != kind) continue;
                return;
            }
            throw new IllegalArgumentException("Unsupported operation for kind " + (Object)((Object)this.vdlType.kind));
        }
    }

    public static final class Builder {
        private final List<PendingType> pendingTypes = new ArrayList<PendingType>();

        public PendingType newPending() {
            PendingType type = new PendingType();
            this.pendingTypes.add(type);
            return type;
        }

        public PendingType newPending(Kind kind) {
            return this.newPending().setKind(kind);
        }

        public PendingType listOf(PendingType elem) {
            return this.newPending(Kind.LIST).setElem(elem);
        }

        public PendingType setOf(PendingType key) {
            return this.newPending(Kind.SET).setKey(key);
        }

        public PendingType mapOf(PendingType key, PendingType elem) {
            return this.newPending(Kind.MAP).setKey(key).setElem(elem);
        }

        public PendingType optionalOf(PendingType elem) {
            return this.newPending(Kind.OPTIONAL).setElem(elem);
        }

        public PendingType builtPendingFromType(VdlType vdlType) {
            return new PendingType(vdlType);
        }

        public void build() {
            for (PendingType type : this.pendingTypes) {
                type.prepare();
            }
            for (PendingType type : this.pendingTypes) {
                type.build();
            }
            this.pendingTypes.clear();
        }
    }
}

