/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.AbstractVdlStruct;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import java.util.HashMap;
import java.util.Map;

public class VdlStruct
extends AbstractVdlStruct {
    private static final long serialVersionUID = 1L;
    private final Map<String, VdlValue> fields = new HashMap<String, VdlValue>();
    private final Map<String, VdlType> fieldTypes = new HashMap<String, VdlType>();

    public VdlStruct(VdlType type) {
        super(type);
        for (VdlField structField : type.getFields()) {
            this.fieldTypes.put(structField.getName(), structField.getType());
        }
    }

    public boolean assignField(String name, VdlValue value) {
        VdlType expectedType = this.fieldTypes.get(name);
        if (expectedType == null || !expectedType.equals(value.vdlType())) {
            return false;
        }
        this.fields.put(name, value);
        return true;
    }

    public VdlValue getField(String name) {
        return this.fields.get(name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdlStruct other = (VdlStruct)obj;
        return this.fields.equals(other.fields);
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public String toString() {
        return this.fields.toString();
    }
}

