/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import java.lang.reflect.Type;

public class VdlOptional<T>
extends VdlValue {
    private static final long serialVersionUID = 1L;
    private final T elem;

    public VdlOptional(VdlType vdlType, T element) {
        super(vdlType);
        this.assertKind(Kind.OPTIONAL);
        this.elem = element;
    }

    public VdlOptional(VdlType vdlType) {
        this(vdlType, null);
    }

    public VdlOptional(Type type) {
        this(Types.getVdlTypeFromReflect(type));
    }

    public static <T extends VdlValue> VdlOptional<T> of(T element) {
        return new VdlOptional<T>(Types.optionalOf(element.vdlType()), element);
    }

    public boolean isNull() {
        return this.elem == null;
    }

    public T getElem() {
        return this.elem;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VdlOptional)) {
            return false;
        }
        VdlOptional other = (VdlOptional)obj;
        return this.elem == null ? other.elem == null : this.elem.equals(other.elem);
    }

    public int hashCode() {
        return this.elem == null ? 0 : this.elem.hashCode();
    }

    public String toString() {
        return this.elem == null ? null : this.elem.toString();
    }
}

