/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;

public class VdlEnum
extends VdlValue {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final int ordinal;

    public VdlEnum(VdlType type, String name) {
        super(type);
        this.assertKind(Kind.ENUM);
        this.ordinal = type.getLabels().indexOf(name);
        if (this.ordinal == -1) {
            throw new IllegalArgumentException("Undeclared enum label " + name);
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public int ordinal() {
        return this.ordinal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VdlEnum)) {
            return false;
        }
        VdlEnum other = (VdlEnum)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

