/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Kind;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class VdlArray<T>
extends VdlValue
implements List<T> {
    private static final long serialVersionUID = 1L;
    private final T[] backingArray;
    private final int start;
    private final int end;

    public VdlArray(VdlType type, T[] backingArray) {
        this(type, backingArray, 0, backingArray.length);
    }

    public VdlArray(VdlType type, T[] backingArray, int start, int end) {
        super(type);
        this.assertKind(Kind.ARRAY);
        if (type.getLength() != end - start) {
            throw new IllegalArgumentException("Length of the array should be the same as specified in VDL type");
        }
        if (start < 0 || end > backingArray.length) {
            throw new IllegalArgumentException("indexes out of range of backing array");
        }
        this.backingArray = backingArray;
        this.start = start;
        this.end = end;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T e : this) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    private static boolean elementsEqual(Object e1, Object e2) {
        if (e1 == null) {
            return e2 == null;
        }
        return e1.equals(e2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (other.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            T e2;
            Object e1 = other.get(i);
            if (VdlArray.elementsEqual(e1, e2 = this.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return Arrays.deepToString(this.backingArray);
    }

    @Override
    public void add(int location, T object) {
        throw new UnsupportedOperationException("add() not supported");
    }

    @Override
    public boolean add(T object) {
        throw new UnsupportedOperationException("add() not supported");
    }

    @Override
    public boolean addAll(int location, Collection<? extends T> collection) {
        throw new UnsupportedOperationException("addAll() not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        throw new UnsupportedOperationException("addAll() not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear() not supported");
    }

    @Override
    public boolean contains(Object obj) {
        return this.indexOf(obj) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int location) {
        if (location < this.start || location >= this.end) {
            throw new IndexOutOfBoundsException("index " + location + " outside of range [" + this.start + "," + this.end + ")");
        }
        return this.backingArray[location];
    }

    @Override
    public int indexOf(Object object) {
        for (int i = this.start; i < this.end; ++i) {
            T t = this.backingArray[i];
            if (!VdlArray.elementsEqual(t, object)) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        for (int i = this.end - 1; i >= this.start; --i) {
            T t = this.backingArray[i];
            if (!VdlArray.elementsEqual(t, object)) continue;
            return i - this.start;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(int location) {
        return new VdlArrayIterator(location);
    }

    @Override
    public T remove(int location) {
        throw new UnsupportedOperationException("remove() not supported");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("remove() not supported");
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("removeAll() not supported");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("retainAll() not supported");
    }

    @Override
    public T set(int location, T object) {
        if (location < this.start || location >= this.end) {
            throw new IndexOutOfBoundsException("index " + location + " outside of range [" + this.start + "," + this.end + ")");
        }
        T prev = this.backingArray[location];
        this.backingArray[location] = object;
        return prev;
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public List<T> subList(int start, int end) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType subListType = builder.newPending(Kind.ARRAY).setLength(end - start).setElem(this.vdlType().getElem());
        builder.build();
        return new VdlArray<T>(subListType.built(), this.backingArray, start, end);
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOfRange(this.backingArray, this.start, this.end);
    }

    @Override
    public <ToType> ToType[] toArray(ToType[] array) {
        if (array.length < this.size()) {
            return Arrays.copyOfRange(this.backingArray, this.start, this.end, array.getClass());
        }
        System.arraycopy(this.backingArray, this.start, array, 0, this.size());
        return array;
    }

    private class VdlArrayIterator
    implements ListIterator<T> {
        private int position;

        public VdlArrayIterator(int index) {
            if (index < 0 || index >= VdlArray.this.size()) {
                throw new IllegalArgumentException("Index out of bounds");
            }
            this.position = index + VdlArray.this.start;
        }

        @Override
        public void add(T object) {
            throw new UnsupportedOperationException("add() not supported");
        }

        @Override
        public boolean hasNext() {
            return this.position < VdlArray.this.end;
        }

        @Override
        public boolean hasPrevious() {
            return this.position > VdlArray.this.start;
        }

        @Override
        public T next() {
            if (this.position >= VdlArray.this.end) {
                throw new NoSuchElementException("beyond end of list");
            }
            return VdlArray.this.backingArray[this.position++];
        }

        @Override
        public int nextIndex() {
            if (this.position >= VdlArray.this.end) {
                return VdlArray.this.end - VdlArray.this.start;
            }
            return this.position - VdlArray.this.start;
        }

        @Override
        public T previous() {
            if (this.position < VdlArray.this.start) {
                throw new NoSuchElementException("before beginning of list");
            }
            return VdlArray.this.backingArray[this.position--];
        }

        @Override
        public int previousIndex() {
            if (this.position < VdlArray.this.start) {
                return 0;
            }
            return this.position - VdlArray.this.start;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() not supported");
        }

        @Override
        public void set(T object) {
            throw new UnsupportedOperationException("set() not supported");
        }
    }
}

