/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlValue;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public final class VdlAny
extends VdlValue {
    private static final long serialVersionUID = 1L;
    public static final VdlType VDL_TYPE = Types.ANY;
    private final Object elem;
    private final VdlType elemType;

    public VdlAny(VdlType vdlType, Object value) {
        super(Types.ANY);
        this.elem = value;
        this.elemType = vdlType;
    }

    public VdlAny(Type type, Object value) {
        this(Types.getVdlTypeFromReflect(type), value);
    }

    public VdlAny(VdlValue value) {
        this(value.vdlType(), (Object)value);
    }

    public VdlAny() {
        this((VdlType)null, null);
    }

    public Object getElem() {
        return this.elem;
    }

    public VdlType getElemType() {
        return this.elemType;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VdlAny other = (VdlAny)obj;
        if (this.elem == null) {
            return other.elem == null;
        }
        if (other.elem == null) {
            return false;
        }
        if (this.elemType != other.elemType) {
            return false;
        }
        if (this.elem.getClass().isArray() != other.elem.getClass().isArray()) {
            return false;
        }
        if (this.elem.getClass().isArray()) {
            if (Array.getLength(this.elem) != Array.getLength(other.elem)) {
                return false;
            }
            for (int i = 0; i < Array.getLength(this.elem); ++i) {
                Object obj2;
                Object obj1 = Array.get(this.elem, i);
                if (Objects.equals(obj1, obj2 = Array.get(other.elem, i))) continue;
                return false;
            }
            return true;
        }
        return this.elem == null ? other.elem == null : this.elem.equals(other.elem);
    }

    public int hashCode() {
        if (this.elem != null && this.elem.getClass().isArray()) {
            Object[] arr = new Object[Array.getLength(this.elem)];
            for (int i = 0; i < Array.getLength(this.elem); ++i) {
                arr[i] = Array.get(this.elem, i);
            }
            return Objects.hash(this.elemType, Arrays.hashCode(arr));
        }
        return Objects.hash(this.elemType, this.elem);
    }

    public String toString() {
        if (this.elem == null) {
            return "any(null)";
        }
        String typeString = this.elemType.toString();
        if (this.elem.getClass().isArray()) {
            StringBuilder sb = new StringBuilder();
            sb.append(typeString);
            sb.append("{");
            for (int i = 0; i < Array.getLength(this.elem); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(Array.get(this.elem, i).toString());
            }
            sb.append("}");
            return sb.toString();
        }
        return typeString + this.elem.toString();
    }
}

