/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.v.v23.security.BlessingPattern;
import io.v.v23.security.BlessingPatternNativeConverter;
import io.v.v23.security.Blessings;
import io.v.v23.security.BlessingsNativeConverter;
import io.v.v23.security.Discharge;
import io.v.v23.security.DischargeNativeConverter;
import io.v.v23.security.access.AccessList;
import io.v.v23.security.access.AccessListNativeConverter;
import io.v.v23.vdl.AbstractVdlStruct;
import io.v.v23.vdl.ArrayLength;
import io.v.v23.vdl.GeneratedFromVdl;
import io.v.v23.vdl.Kind;
import io.v.v23.vdl.NativeTime;
import io.v.v23.vdl.NativeTypes;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlArray;
import io.v.v23.vdl.VdlBool;
import io.v.v23.vdl.VdlByte;
import io.v.v23.vdl.VdlEnum;
import io.v.v23.vdl.VdlField;
import io.v.v23.vdl.VdlFloat32;
import io.v.v23.vdl.VdlFloat64;
import io.v.v23.vdl.VdlInt16;
import io.v.v23.vdl.VdlInt32;
import io.v.v23.vdl.VdlInt64;
import io.v.v23.vdl.VdlInt8;
import io.v.v23.vdl.VdlList;
import io.v.v23.vdl.VdlMap;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlSet;
import io.v.v23.vdl.VdlString;
import io.v.v23.vdl.VdlStruct;
import io.v.v23.vdl.VdlType;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint16;
import io.v.v23.vdl.VdlUint32;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlUnion;
import io.v.v23.verror.VException;
import io.v.v23.verror.VExceptionVdlConverter;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import org.joda.time.DateTime;
import org.joda.time.Duration;

public final class Types {
    public static final VdlType ANY = Types.createPrimitiveType(Kind.ANY);
    public static final VdlType BOOL = Types.createPrimitiveType(Kind.BOOL);
    public static final VdlType BYTE = Types.createPrimitiveType(Kind.BYTE);
    public static final VdlType UINT16 = Types.createPrimitiveType(Kind.UINT16);
    public static final VdlType UINT32 = Types.createPrimitiveType(Kind.UINT32);
    public static final VdlType UINT64 = Types.createPrimitiveType(Kind.UINT64);
    public static final VdlType INT8 = Types.createPrimitiveType(Kind.INT8);
    public static final VdlType INT16 = Types.createPrimitiveType(Kind.INT16);
    public static final VdlType INT32 = Types.createPrimitiveType(Kind.INT32);
    public static final VdlType INT64 = Types.createPrimitiveType(Kind.INT64);
    public static final VdlType FLOAT32 = Types.createPrimitiveType(Kind.FLOAT32);
    public static final VdlType FLOAT64 = Types.createPrimitiveType(Kind.FLOAT64);
    public static final VdlType STRING = Types.createPrimitiveType(Kind.STRING);
    public static final VdlType TYPEOBJECT = Types.createPrimitiveType(Kind.TYPEOBJECT);
    private static final Map<Type, VdlType> typeCache = new ConcurrentHashMap<Type, VdlType>();
    private static final Map<VdlType, Type> typeRegistry = new ConcurrentHashMap<VdlType, Type>();
    private static final Map<Type, NativeTypes.Converter> nativeTypeRegistry = new ConcurrentHashMap<Type, NativeTypes.Converter>();

    private static void registerNativeType(Type nativeType, NativeTypes.Converter converter) {
        VdlType vdlType = Types.getVdlTypeFromReflect(converter.getWireType());
        typeCache.put(nativeType, vdlType);
        typeRegistry.put(vdlType, nativeType);
        nativeTypeRegistry.put(nativeType, converter);
    }

    private static VdlType createPrimitiveType(Kind kind) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(kind);
        builder.build();
        return pending.built();
    }

    public static VdlType primitiveTypeFromKind(Kind kind) {
        switch (kind) {
            case ANY: {
                return ANY;
            }
            case BOOL: {
                return BOOL;
            }
            case BYTE: {
                return BYTE;
            }
            case UINT16: {
                return UINT16;
            }
            case UINT32: {
                return UINT32;
            }
            case UINT64: {
                return UINT64;
            }
            case INT8: {
                return INT8;
            }
            case INT16: {
                return INT16;
            }
            case INT32: {
                return INT32;
            }
            case INT64: {
                return INT64;
            }
            case FLOAT32: {
                return FLOAT32;
            }
            case FLOAT64: {
                return FLOAT64;
            }
            case STRING: {
                return STRING;
            }
            case TYPEOBJECT: {
                return TYPEOBJECT;
            }
        }
        throw new RuntimeException("Unknown primitive kind " + (Object)((Object)kind));
    }

    public static VdlType enumOf(String ... labels) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.ENUM);
        for (String label : labels) {
            pending.addLabel(label);
        }
        builder.build();
        return pending.built();
    }

    public static VdlType arrayOf(int len, VdlType elem) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.ARRAY).setLength(len).setElem(elem);
        builder.build();
        return pending.built();
    }

    public static VdlType listOf(VdlType elem) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.LIST).setElem(elem);
        builder.build();
        return pending.built();
    }

    public static VdlType setOf(VdlType key) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.SET).setKey(key);
        builder.build();
        return pending.built();
    }

    public static VdlType mapOf(VdlType key, VdlType elem) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.MAP).setKey(key).setElem(elem);
        builder.build();
        return pending.built();
    }

    public static VdlType structOf(VdlField ... fields) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.STRUCT);
        for (VdlField field : fields) {
            pending.addField(field.getName(), field.getType());
        }
        builder.build();
        return pending.built();
    }

    public static VdlType unionOf(VdlField ... fields) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.UNION);
        for (VdlField field : fields) {
            pending.addField(field.getName(), field.getType());
        }
        builder.build();
        return pending.built();
    }

    public static VdlType optionalOf(VdlType elem) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending(Kind.OPTIONAL).setElem(elem);
        builder.build();
        return pending.built();
    }

    public static VdlType named(String name, VdlType base) {
        VdlType.Builder builder = new VdlType.Builder();
        VdlType.PendingType pending = builder.newPending().assignBase(base).setName(name);
        builder.build();
        return pending.built();
    }

    public static NativeTypes.Converter getNativeTypeConverter(Type type) {
        if (type instanceof Class && VException.class.isAssignableFrom((Class)type)) {
            type = VException.class;
        }
        return nativeTypeRegistry.get(type);
    }

    public static VdlType getVdlTypeFromReflect(Type type) {
        if (typeCache.containsKey(type)) {
            return typeCache.get(type);
        }
        return Types.synchronizedLookupOrBuildType(type);
    }

    public static Type getReflectTypeForVdl(VdlType vdlType) {
        Type type = typeRegistry.get(vdlType);
        if (type != null) {
            return type;
        }
        if (!Strings.isNullOrEmpty((String)vdlType.getName())) {
            throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - named type is unregistered");
        }
        switch (vdlType.getKind()) {
            case ARRAY: 
            case ENUM: 
            case STRUCT: 
            case UNION: {
                throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - illegal unnamed union");
            }
            case ANY: {
                return VdlAny.class;
            }
            case BOOL: {
                return Boolean.class;
            }
            case BYTE: {
                return Byte.class;
            }
            case FLOAT32: {
                return Float.class;
            }
            case FLOAT64: {
                return Double.class;
            }
            case INT8: {
                return VdlInt8.class;
            }
            case INT16: {
                return Short.class;
            }
            case INT32: {
                return Integer.class;
            }
            case INT64: {
                return Long.class;
            }
            case LIST: {
                if (vdlType.getElem().getKind() == Kind.BYTE) {
                    return byte[].class;
                }
                Type elem = Types.getReflectTypeForVdl(vdlType.getElem());
                if (elem != null) {
                    return new ParameterizedTypeImpl((Type)((Object)VdlList.class), elem);
                }
                throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - unknown list elem type");
            }
            case MAP: {
                Type key = Types.getReflectTypeForVdl(vdlType.getKey());
                Type elem = Types.getReflectTypeForVdl(vdlType.getElem());
                if (key != null && elem != null) {
                    return new ParameterizedTypeImpl((Type)((Object)VdlMap.class), key, elem);
                }
                throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - unknown map key or elem type");
            }
            case OPTIONAL: {
                Type elem = Types.getReflectTypeForVdl(vdlType.getElem());
                if (elem != null) {
                    return new ParameterizedTypeImpl((Type)((Object)VdlOptional.class), elem);
                }
                throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - unkown optional elem type");
            }
            case SET: {
                Type key = Types.getReflectTypeForVdl(vdlType.getKey());
                if (key != null) {
                    return new ParameterizedTypeImpl((Type)((Object)VdlSet.class), key);
                }
                throw new IllegalArgumentException("Can't build java type for VDL type " + vdlType + " - unknown set key type");
            }
            case STRING: {
                return String.class;
            }
            case TYPEOBJECT: {
                return VdlTypeObject.class;
            }
            case UINT16: {
                return VdlUint16.class;
            }
            case UINT32: {
                return VdlUint32.class;
            }
            case UINT64: {
                return VdlUint64.class;
            }
        }
        throw new IllegalArgumentException("Unsupported VDL type: " + vdlType);
    }

    public static Class<?> loadClassForVdlName(String name) {
        Object[] parts = name.split("/");
        for (int i = 0; i < parts.length - 1; ++i) {
            List<String> subparts = Arrays.asList(parts[i].split("\\."));
            Collections.reverse(subparts);
            parts[i] = Joiner.on((String)".").join(subparts);
        }
        String className = Joiner.on((String)".").join(parts);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return null;
        }
    }

    private static synchronized VdlType synchronizedLookupOrBuildType(Type type) {
        if (typeCache.containsKey(type)) {
            return typeCache.get(type);
        }
        ReflectToVdlTypeBuilder builder = new ReflectToVdlTypeBuilder();
        VdlType.PendingType pendingType = builder.lookupOrBuildPending(type);
        builder.buildAndCache();
        return pendingType.built();
    }

    static {
        typeCache.put((Type)((Object)VdlAny.class), ANY);
        typeCache.put((Type)((Object)VdlBool.class), BOOL);
        typeCache.put((Type)((Object)VdlByte.class), BYTE);
        typeCache.put((Type)((Object)VdlUint16.class), UINT16);
        typeCache.put((Type)((Object)VdlUint32.class), UINT32);
        typeCache.put((Type)((Object)VdlUint64.class), UINT64);
        typeCache.put((Type)((Object)VdlInt8.class), INT8);
        typeCache.put((Type)((Object)VdlInt16.class), INT16);
        typeCache.put((Type)((Object)VdlInt32.class), INT32);
        typeCache.put((Type)((Object)VdlInt64.class), INT64);
        typeCache.put((Type)((Object)VdlFloat32.class), FLOAT32);
        typeCache.put((Type)((Object)VdlFloat64.class), FLOAT64);
        typeCache.put((Type)((Object)VdlString.class), STRING);
        typeCache.put((Type)((Object)VdlTypeObject.class), TYPEOBJECT);
        typeCache.put(Boolean.TYPE, BOOL);
        typeCache.put((Type)((Object)Boolean.class), BOOL);
        typeCache.put(Byte.TYPE, BYTE);
        typeCache.put((Type)((Object)Byte.class), BYTE);
        typeCache.put(Short.TYPE, INT16);
        typeCache.put((Type)((Object)Short.class), INT16);
        typeCache.put(Integer.TYPE, INT32);
        typeCache.put((Type)((Object)Integer.class), INT32);
        typeCache.put(Long.TYPE, INT64);
        typeCache.put((Type)((Object)Long.class), INT64);
        typeCache.put(Float.TYPE, FLOAT32);
        typeCache.put((Type)((Object)Float.class), FLOAT32);
        typeCache.put(Double.TYPE, FLOAT64);
        typeCache.put((Type)((Object)Double.class), FLOAT64);
        typeCache.put((Type)((Object)String.class), STRING);
        Types.registerNativeType(VException.class, VExceptionVdlConverter.INSTANCE);
        Types.registerNativeType(DateTime.class, NativeTime.DateTimeConverter.INSTANCE);
        Types.registerNativeType(Duration.class, NativeTime.DurationConverter.INSTANCE);
        Types.registerNativeType(Discharge.class, DischargeNativeConverter.INSTANCE);
        Types.registerNativeType(Blessings.class, BlessingsNativeConverter.INSTANCE);
        Types.registerNativeType(BlessingPattern.class, BlessingPatternNativeConverter.INSTANCE);
        Types.registerNativeType(AccessList.class, AccessListNativeConverter.INSTANCE);
    }

    private static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Type rawType;
        private final Type[] arguments;

        public ParameterizedTypeImpl(Type rawType, Type ... arguments) {
            this.rawType = rawType;
            this.arguments = arguments;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.arguments;
        }

        @Override
        public Type getRawType() {
            return this.rawType;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    private static final class ReflectToVdlTypeBuilder {
        private final VdlType.Builder builder = new VdlType.Builder();
        private final Map<Type, VdlType.PendingType> pendingTypes = new HashMap<Type, VdlType.PendingType>();

        public void buildAndCache() {
            this.builder.build();
            for (Map.Entry<Type, VdlType.PendingType> entry : this.pendingTypes.entrySet()) {
                Type reflectType = entry.getKey();
                VdlType vdlType = entry.getValue().built();
                typeCache.put(reflectType, vdlType);
                if (Strings.isNullOrEmpty((String)vdlType.getName())) continue;
                typeRegistry.put(vdlType, reflectType);
            }
        }

        public VdlType.PendingType lookupOrBuildPending(Type type) {
            VdlType.PendingType vdlType = this.lookupType(type);
            if (vdlType != null) {
                return vdlType;
            }
            return this.buildPendingFromType(type);
        }

        private VdlType.PendingType lookupType(Type type) {
            if (typeCache.containsKey(type)) {
                return this.builder.builtPendingFromType((VdlType)typeCache.get(type));
            }
            if (this.pendingTypes.containsKey(type)) {
                return this.pendingTypes.get(type);
            }
            return null;
        }

        private VdlType.PendingType buildPendingFromType(Type type) {
            VdlType.PendingType pending;
            Type[] elementTypes;
            Class<List> klass;
            if (type instanceof Class) {
                Class klass2 = (Class)type;
                return this.buildPendingFromClass(klass2);
            }
            if (type instanceof ParameterizedType) {
                klass = (Class<List>)((Object)((ParameterizedType)type).getRawType());
                elementTypes = ((ParameterizedType)type).getActualTypeArguments();
            } else if (type instanceof GenericArrayType) {
                klass = List.class;
                elementTypes = new Type[]{((GenericArrayType)type).getGenericComponentType()};
            } else {
                throw new IllegalArgumentException("Unable to create VDL Type for type " + type);
            }
            if (List.class.isAssignableFrom(klass)) {
                pending = this.builder.listOf(this.lookupOrBuildPending(elementTypes[0]));
            } else if (Set.class.isAssignableFrom(klass)) {
                pending = this.builder.setOf(this.lookupOrBuildPending(elementTypes[0]));
            } else if (Map.class.isAssignableFrom(klass)) {
                pending = this.builder.mapOf(this.lookupOrBuildPending(elementTypes[0]), this.lookupOrBuildPending(elementTypes[1]));
            } else if (VdlOptional.class.isAssignableFrom(klass)) {
                pending = this.builder.optionalOf(this.lookupOrBuildPending(elementTypes[0]));
            } else {
                throw new IllegalArgumentException("Unable to create VDL Type for type " + type);
            }
            this.pendingTypes.put(type, pending);
            return pending;
        }

        private VdlType.PendingType buildPendingFromClass(Class<?> klass) {
            if (klass.isArray()) {
                VdlType.PendingType pending = this.builder.listOf(this.lookupOrBuildPending(klass.getComponentType()));
                this.pendingTypes.put(klass, pending);
                return pending;
            }
            if (klass.isAssignableFrom(List.class)) {
                throw new IllegalArgumentException("Unable to create a VDL type from List.class.  Consider creating a type using a TypeToken.");
            }
            if (klass.isAssignableFrom(Set.class)) {
                throw new IllegalArgumentException("Unable to create a VDL type from Set.class.  Consider creating a type using a TypeToken.");
            }
            if (klass.isAssignableFrom(Map.class)) {
                throw new IllegalArgumentException("Unable to create a VDL type from Map.class.  Consider creating a type using a TypeToken.");
            }
            VdlType.PendingType pending = this.builder.newPending();
            this.pendingTypes.put(klass, pending);
            Class<?> superClass = klass.getSuperclass();
            if (superClass == VdlEnum.class) {
                this.populateEnum(pending, klass);
            } else if (superClass == AbstractVdlStruct.class) {
                if (klass == VdlStruct.class) {
                    throw new IllegalArgumentException("Unable to create VDL Type for " + klass);
                }
                this.populateStruct(pending, klass);
            } else if (superClass == VdlUnion.class) {
                this.populateUnion(pending, klass);
            } else if (superClass == VdlArray.class) {
                this.populateArray(pending, klass);
            } else if (superClass != null && superClass != Object.class) {
                pending.assignBase(this.lookupOrBuildPending(klass.getGenericSuperclass()));
            } else {
                this.populateStruct(pending, klass);
            }
            GeneratedFromVdl annotation = klass.getAnnotation(GeneratedFromVdl.class);
            if (annotation != null) {
                pending.setName(annotation.name());
            } else if (klass.getCanonicalName() != null) {
                pending.setName(klass.getCanonicalName());
            }
            return pending;
        }

        private void populateEnum(VdlType.PendingType pending, Class<?> klass) {
            pending.setKind(Kind.ENUM);
            TreeMap<Integer, String> labels = new TreeMap<Integer, String>();
            for (Field field : klass.getDeclaredFields()) {
                GeneratedFromVdl annotation = field.getAnnotation(GeneratedFromVdl.class);
                if (annotation == null) continue;
                labels.put(annotation.index(), annotation.name());
            }
            for (Map.Entry entry : labels.entrySet()) {
                pending.addLabel((String)entry.getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void populateStruct(VdlType.PendingType pending, Class<?> klass) {
            void var7_10;
            pending.setKind(Kind.STRUCT);
            TreeMap<Integer, PendingVdlField> fields = new TreeMap<Integer, PendingVdlField>();
            boolean hasFieldAnnotations = false;
            Field[] fieldArray = klass.getDeclaredFields();
            int n = fieldArray.length;
            boolean bl = false;
            while (var7_10 < n) {
                Field field = fieldArray[var7_10];
                GeneratedFromVdl annotation = field.getAnnotation(GeneratedFromVdl.class);
                if (annotation != null) {
                    hasFieldAnnotations = true;
                    break;
                }
                ++var7_10;
            }
            int fieldIndex = 0;
            for (Field field : klass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                if (Character.isUpperCase(field.getName().charAt(0))) {
                    throw new IllegalArgumentException("Java field names must be lower-cased");
                }
                GeneratedFromVdl annotation = field.getAnnotation(GeneratedFromVdl.class);
                if (annotation != null) {
                    fields.put(annotation.index(), new PendingVdlField(annotation.name(), this.lookupOrBuildPending(field.getGenericType())));
                    continue;
                }
                if (hasFieldAnnotations) continue;
                fields.put(++fieldIndex, new PendingVdlField(ReflectToVdlTypeBuilder.firstCharToUpper(field.getName()), this.lookupOrBuildPending(field.getGenericType())));
            }
            for (Map.Entry entry : fields.entrySet()) {
                pending.addField(((PendingVdlField)entry.getValue()).name, ((PendingVdlField)entry.getValue()).type);
            }
        }

        private void populateUnion(VdlType.PendingType pending, Class<?> klass) {
            pending.setKind(Kind.UNION);
            TreeMap<Integer, PendingVdlField> fields = new TreeMap<Integer, PendingVdlField>();
            for (Class<?> unionClass : klass.getDeclaredClasses()) {
                Type type;
                GeneratedFromVdl annotation = unionClass.getAnnotation(GeneratedFromVdl.class);
                if (annotation == null) continue;
                try {
                    type = unionClass.getDeclaredField("elem").getGenericType();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create VDL Type for type " + klass, e);
                }
                String name = annotation.name().substring(annotation.name().lastIndexOf(36) + 1);
                fields.put(annotation.index(), new PendingVdlField(name, this.lookupOrBuildPending(type)));
            }
            for (Map.Entry entry : fields.entrySet()) {
                pending.addField(((PendingVdlField)entry.getValue()).name, ((PendingVdlField)entry.getValue()).type);
            }
        }

        private void populateArray(VdlType.PendingType pending, Class<?> klass) {
            pending.setKind(Kind.ARRAY);
            Type elementType = ((ParameterizedType)klass.getGenericSuperclass()).getActualTypeArguments()[0];
            pending.setElem(this.lookupOrBuildPending(elementType));
            try {
                ArrayLength length = klass.getAnnotation(ArrayLength.class);
                pending.setLength(length.value());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create VDL Type for type " + klass, e);
            }
        }

        private static String firstCharToUpper(String str) {
            return Character.toUpperCase(str.charAt(0)) + str.substring(1);
        }

        private static final class PendingVdlField {
            final String name;
            final VdlType.PendingType type;

            public PendingVdlField(String name, VdlType.PendingType type) {
                this.name = name;
                this.type = type;
            }
        }
    }
}

