/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.vdl;

import io.v.v23.vdl.NativeTypes;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.time.Duration;
import io.v.v23.vdlroot.time.Time;
import java.lang.reflect.Type;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class NativeTime {
    static final long MILLIS_PER_SECOND = 1000L;
    static final long NANOS_PER_MILLISECOND = 1000000L;
    static final long SECONDS_PER_DAY = 86400L;
    static final long JAVA_EPOCH = 62135596800000L;

    static final class DateTimeConverter
    extends NativeTypes.Converter {
        static final DateTimeConverter INSTANCE = new DateTimeConverter();

        private DateTimeConverter() {
            super((Type)((Object)Time.class));
        }

        @Override
        public VdlValue vdlValueFromNative(Object nativeValue) {
            DateTimeConverter.assertInstanceOf(nativeValue, DateTime.class);
            long millis = ((DateTime)nativeValue).getMillis() + 62135596800000L;
            return new Time(millis / 1000L, (int)(millis % 1000L * 1000000L));
        }

        @Override
        public Object nativeFromVdlValue(VdlValue value) {
            DateTimeConverter.assertInstanceOf(value, Time.class);
            Time wireTime = (Time)value;
            long millis = wireTime.getSeconds() * 1000L - 62135596800000L + (long)wireTime.getNanos() / 1000000L;
            return new DateTime(millis, DateTimeZone.UTC);
        }
    }

    static final class DurationConverter
    extends NativeTypes.Converter {
        static final DurationConverter INSTANCE = new DurationConverter();

        private DurationConverter() {
            super((Type)((Object)Duration.class));
        }

        @Override
        public VdlValue vdlValueFromNative(Object nativeValue) {
            DurationConverter.assertInstanceOf(nativeValue, org.joda.time.Duration.class);
            long millis = ((org.joda.time.Duration)nativeValue).getMillis();
            return new Duration(millis / 1000L, (int)(millis % 1000L * 1000000L));
        }

        @Override
        public Object nativeFromVdlValue(VdlValue value) {
            DurationConverter.assertInstanceOf(value, Duration.class);
            Duration wireDuration = (Duration)value;
            return new org.joda.time.Duration(wireDuration.getSeconds() * 1000L + (long)wireDuration.getNanos() / 1000000L);
        }
    }
}

