/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.naming.NamingUtil;
import io.v.v23.InputChannel;
import io.v.v23.InputChannels;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.naming.GlobReply;
import io.v.v23.security.BlessingPattern;
import io.v.v23.security.access.AccessList;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.Id;
import io.v.v23.verror.VException;
import java.io.UnsupportedEncodingException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.CheckReturnValue;

public class Util {
    public static final char EscapeChar = '\\';

    private Util() {
    }

    public static String encode(String s) {
        return NamingUtil.encodeAsNameElement(s);
    }

    public static String decode(String s) {
        return NamingUtil.decodeFromNameElement(s);
    }

    public static String encodeId(Id id) {
        return Util.encode(id.getBlessing() + "," + id.getName());
    }

    public static Id decodeId(String s) throws VException {
        String decoded = Util.decode(s);
        String[] parts = decoded.split(",", 2);
        if (parts.length != 2) {
            throw new IllegalArgumentException("Failed to decode id: " + s);
        }
        Id id = new Id(parts[0], parts[1]);
        return id;
    }

    public static String escapePattern(String s) {
        return s.replaceAll("[\\\\%_]", "\\\\$0");
    }

    public static CollectionRowPattern rowPrefixPattern(Id cxId, String keyPrefix) {
        return new CollectionRowPattern(Util.escapePattern(cxId.getBlessing()), Util.escapePattern(cxId.getName()), Util.escapePattern(keyPrefix) + "%");
    }

    public static String prefixRangeStart(String prefix) {
        return prefix;
    }

    public static String prefixRangeLimit(String prefix) {
        try {
            int last;
            byte[] bytes = prefix.getBytes("ISO8859-1");
            for (last = bytes.length - 1; last >= 0 && bytes[last] == -1; --last) {
            }
            if (last < 0) {
                return "";
            }
            int n = last;
            bytes[n] = (byte)(bytes[n] + 1);
            return new String(bytes, 0, last + 1, "ISO8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("JVM must support ISO8859-1 char encoding", e);
        }
    }

    @CheckReturnValue
    public static ListenableFuture<List<Id>> listChildIds(VContext context, String parentFullName) {
        InputChannel<GlobReply> input = V.getNamespace(context).glob(context, NamingUtil.join(parentFullName, "*"));
        return VFutures.withUserLandChecks(context, Futures.transform(InputChannels.asList(InputChannels.transform(context, input, new InputChannels.TransformFunction<GlobReply, Id>(){

            @Override
            public Id apply(GlobReply from) throws VException {
                return Util.idFromGlobReply(from);
            }
        })), (Function)new Function<List<Id>, List<Id>>(){

            public List<Id> apply(List<Id> input) {
                return Ordering.from((Comparator)new IdComparator()).immutableSortedCopy(input);
            }
        }));
    }

    private static Id idFromGlobReply(GlobReply reply) throws VException {
        if (reply instanceof GlobReply.Entry) {
            String fullName = ((GlobReply.Entry)reply).getElem().getName();
            int idx = fullName.lastIndexOf(47);
            if (idx == -1) {
                throw new VException("Unexpected glob() reply name: " + fullName);
            }
            String encName = fullName.substring(idx + 1, fullName.length());
            return Util.decodeId(encName);
        }
        if (reply instanceof GlobReply.Error) {
            return null;
        }
        if (reply == null) {
            throw new VException("null glob() reply");
        }
        throw new VException("Unrecognized glob() reply type: " + reply.getClass());
    }

    public static byte[] getBytes(String s) {
        if (s == null) {
            s = "";
        }
        return s.getBytes(Charsets.UTF_8);
    }

    public static String getString(byte[] bytes) {
        return new String(bytes, Charsets.UTF_8);
    }

    public static String AppBlessingFromContext(VContext ctx) {
        return "v.io:a:xyz";
    }

    public static String UserBlessingFromContext(VContext ctx) {
        return "v.io:u:sam";
    }

    public static Permissions filterPermissionsByTags(Permissions perms, Iterable<Tag> tags) {
        Permissions filtered = new Permissions();
        for (Tag tag : tags) {
            String tagStr = tag.getValue();
            AccessList acl = (AccessList)perms.get(tagStr);
            if (acl == null) continue;
            AccessList aclCopy = new AccessList(new ArrayList<BlessingPattern>(acl.getIn()), new ArrayList<String>(acl.getNotIn()));
            filtered.put(tagStr, aclCopy);
        }
        return filtered;
    }

    private static class IdComparator
    implements Comparator<Id> {
        private IdComparator() {
        }

        @Override
        public int compare(Id a, Id b) {
            Collator collator = Collator.getInstance();
            if (a.getBlessing() != b.getBlessing()) {
                return collator.compare(a.getBlessing(), b.getBlessing());
            }
            return collator.compare(a.getName(), b.getName());
        }
    }
}

