/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.services.syncbase.DatabaseClient;
import io.v.v23.services.syncbase.DatabaseClientFactory;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SyncgroupManagerClient;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.services.syncbase.SyncgroupSpec;
import io.v.v23.syncbase.Syncgroup;
import java.util.List;
import java.util.Map;

class SyncgroupImpl
implements Syncgroup {
    private final Id id;
    private final String dbFullName;
    private final DatabaseClient dbClient;

    SyncgroupImpl(String dbFullName, Id id) {
        this.id = id;
        this.dbFullName = dbFullName;
        this.dbClient = DatabaseClientFactory.getDatabaseClient(dbFullName);
    }

    @Override
    public ListenableFuture<Void> create(VContext ctx, SyncgroupSpec spec, SyncgroupMemberInfo info) {
        return this.dbClient.createSyncgroup(ctx, this.id, spec, info);
    }

    @Override
    public ListenableFuture<SyncgroupSpec> join(VContext ctx, String syncbaseName, List<String> expectedSyncbaseBlessings, SyncgroupMemberInfo info) {
        return this.dbClient.joinSyncgroup(ctx, syncbaseName, expectedSyncbaseBlessings, this.id, info);
    }

    @Override
    public ListenableFuture<Void> leave(VContext ctx) {
        return this.dbClient.leaveSyncgroup(ctx, this.id);
    }

    @Override
    public ListenableFuture<Void> destroy(VContext ctx) {
        return this.dbClient.destroySyncgroup(ctx, this.id);
    }

    @Override
    public ListenableFuture<Void> eject(VContext ctx, String member) {
        return this.dbClient.ejectFromSyncgroup(ctx, this.id, member);
    }

    @Override
    public ListenableFuture<Map<String, SyncgroupSpec>> getSpec(VContext ctx) {
        return VFutures.withUserLandChecks(ctx, Futures.transform(this.dbClient.getSyncgroupSpec(ctx, this.id), (Function)new Function<SyncgroupManagerClient.GetSyncgroupSpecOut, Map<String, SyncgroupSpec>>(){

            public Map<String, SyncgroupSpec> apply(SyncgroupManagerClient.GetSyncgroupSpecOut spec) {
                return ImmutableMap.of((Object)spec.version, (Object)spec.spec);
            }
        }));
    }

    @Override
    public ListenableFuture<Void> setSpec(VContext ctx, SyncgroupSpec spec, String version) {
        return this.dbClient.setSyncgroupSpec(ctx, this.id, spec, version);
    }

    @Override
    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getMembers(VContext ctx) {
        return this.dbClient.getSyncgroupMembers(ctx, this.id);
    }
}

