/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.naming.NamingUtil;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.RowClient;
import io.v.v23.services.syncbase.RowClientFactory;
import io.v.v23.syncbase.Row;
import io.v.v23.syncbase.util.Util;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vom.VomUtil;

class RowImpl
implements Row {
    private final String fullName;
    private final String key;
    private final BatchHandle batchHandle;
    private final RowClient client;

    RowImpl(String parentFullName, String key, BatchHandle batchHandle) {
        this.fullName = NamingUtil.join(parentFullName, Util.encode(key));
        this.key = key;
        this.batchHandle = batchHandle;
        this.client = RowClientFactory.getRowClient(this.fullName);
    }

    @Override
    public String key() {
        return this.key;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public ListenableFuture<Boolean> exists(VContext ctx) {
        return this.client.exists(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx) {
        return this.client.delete(ctx, this.batchHandle);
    }

    @Override
    public <T> ListenableFuture<T> get(VContext ctx, final Class<T> clazz) {
        return VFutures.withUserLandChecks(ctx, Futures.transform(this.client.get(ctx, this.batchHandle), (AsyncFunction)new AsyncFunction<VdlAny, T>(){

            public ListenableFuture<T> apply(VdlAny vdlAny) throws Exception {
                byte[] encodedBytes = VomUtil.encode((Object)vdlAny, VdlAny.VDL_TYPE);
                Object decodedObject = VomUtil.decode(encodedBytes, clazz);
                return Futures.immediateFuture((Object)decodedObject);
            }
        }));
    }

    @Override
    public ListenableFuture<Void> put(VContext ctx, Object value) {
        return this.client.put(ctx, this.batchHandle, new VdlAny(value.getClass(), value));
    }
}

