/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.ListenableFutureCallback;
import io.v.impl.google.naming.NamingUtil;
import io.v.v23.InputChannel;
import io.v.v23.InputChannels;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.security.BlessingPattern;
import io.v.v23.security.access.AccessList;
import io.v.v23.security.access.Constants;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.BatchOptions;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.DatabaseClient;
import io.v.v23.services.syncbase.DatabaseClientFactory;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SchemaMetadata;
import io.v.v23.services.syncbase.StoreChange;
import io.v.v23.services.watch.Change;
import io.v.v23.services.watch.ResumeMarker;
import io.v.v23.syncbase.BatchDatabase;
import io.v.v23.syncbase.BlobReader;
import io.v.v23.syncbase.BlobReaderImpl;
import io.v.v23.syncbase.BlobWriter;
import io.v.v23.syncbase.BlobWriterImpl;
import io.v.v23.syncbase.ChangeType;
import io.v.v23.syncbase.Collection;
import io.v.v23.syncbase.CollectionImpl;
import io.v.v23.syncbase.Database;
import io.v.v23.syncbase.DatabaseCore;
import io.v.v23.syncbase.Schema;
import io.v.v23.syncbase.Syncgroup;
import io.v.v23.syncbase.SyncgroupImpl;
import io.v.v23.syncbase.WatchChange;
import io.v.v23.syncbase.util.Util;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.Types;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.verror.NotImplementedException;
import io.v.v23.verror.VException;
import io.v.v23.vom.VomUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class DatabaseImpl
implements Database,
BatchDatabase {
    private final String parentFullName;
    private final String fullName;
    private final Id id;
    private final BatchHandle batchHandle;
    private final Schema schema;
    private final DatabaseClient client;

    private native void nativeListenForInvites(VContext var1, Database.InviteHandler var2) throws VException;

    DatabaseImpl(String parentFullName, Id id, Schema schema, BatchHandle batchHandle) {
        this.parentFullName = parentFullName;
        this.fullName = NamingUtil.join(parentFullName, Util.encodeId(id));
        this.id = id;
        this.batchHandle = batchHandle;
        this.schema = schema;
        this.client = DatabaseClientFactory.getDatabaseClient(this.fullName);
    }

    private static List<String> splitInTwo(String str, String separator) {
        Iterator iter = Splitter.on((String)separator).limit(2).split((CharSequence)str).iterator();
        return ImmutableList.of((Object)(iter.hasNext() ? (String)iter.next() : ""), (Object)(iter.hasNext() ? (String)iter.next() : ""));
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public Collection getCollection(VContext ctx, String name) {
        String blessing = Util.UserBlessingFromContext(ctx);
        Id id = new Id(blessing, name);
        return this.getCollection(id);
    }

    @Override
    public Collection getCollection(Id collectionId) {
        return new CollectionImpl(this.fullName, collectionId, this.batchHandle);
    }

    @Override
    public ListenableFuture<List<Id>> listCollections(VContext ctx) {
        return this.client.listCollections(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<DatabaseCore.QueryResults> exec(VContext ctx, String query) {
        return this.execInternal(ctx, query, null);
    }

    @Override
    public ListenableFuture<DatabaseCore.QueryResults> exec(VContext ctx, String query, List<Object> paramValues, List<Type> paramTypes) {
        Preconditions.checkNotNull(paramValues);
        Preconditions.checkNotNull(paramTypes);
        if (paramValues.size() != paramTypes.size()) {
            throw new IllegalArgumentException("Length of paramValues and paramTypes is not equal");
        }
        ArrayList<VdlAny> params = new ArrayList<VdlAny>();
        try {
            Iterator<Object> v = paramValues.iterator();
            Iterator<Type> t = paramTypes.iterator();
            while (v.hasNext() && t.hasNext()) {
                params.add(new VdlAny(VomUtil.valueOf(v.next(), t.next())));
            }
        }
        catch (VException e) {
            return VFutures.withUserLandChecks(ctx, Futures.immediateFailedFuture((Throwable)e));
        }
        return this.execInternal(ctx, query, params);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext ctx, Permissions perms, String version) {
        return this.client.setPermissions(ctx, perms, version);
    }

    @Override
    public ListenableFuture<Map<String, Permissions>> getPermissions(VContext ctx) {
        return VFutures.withUserLandChecks(ctx, Futures.transform(this.client.getPermissions(ctx), (Function)new Function<ObjectClient.GetPermissionsOut, Map<String, Permissions>>(){

            public Map<String, Permissions> apply(ObjectClient.GetPermissionsOut perms) {
                return ImmutableMap.of((Object)perms.version, (Object)perms.perms);
            }
        }));
    }

    @Override
    public ListenableFuture<Boolean> exists(VContext ctx) {
        return this.client.exists(ctx);
    }

    @Override
    public ListenableFuture<Void> create(VContext ctx, Permissions perms) {
        VdlOptional<SchemaMetadata> metadataOpt;
        VdlOptional<SchemaMetadata> vdlOptional = metadataOpt = this.schema != null ? VdlOptional.of(this.schema.getMetadata()) : new VdlOptional<SchemaMetadata>(Types.optionalOf(SchemaMetadata.VDL_TYPE));
        if (perms == null) {
            String blessing = Util.UserBlessingFromContext(ctx);
            AccessList acl = new AccessList((List<BlessingPattern>)ImmutableList.of((Object)new BlessingPattern(blessing)), (List<String>)ImmutableList.of());
            perms = new Permissions((Map<String, AccessList>)ImmutableMap.of((Object)Constants.RESOLVE.getValue(), (Object)acl, (Object)Constants.READ.getValue(), (Object)acl, (Object)Constants.WRITE.getValue(), (Object)acl, (Object)Constants.ADMIN.getValue(), (Object)acl));
        }
        return this.client.create(ctx, metadataOpt, perms);
    }

    @Override
    public ListenableFuture<Void> destroy(VContext ctx) {
        return this.client.destroy(ctx);
    }

    @Override
    public ListenableFuture<BatchDatabase> beginBatch(VContext ctx, BatchOptions opts) {
        ListenableFuture<BatchHandle> batchFuture = this.client.beginBatch(ctx, opts);
        final String parentFullName = this.parentFullName;
        final Id id = this.id;
        final Schema schema = this.schema;
        return VFutures.withUserLandChecks(ctx, Futures.transform(batchFuture, (Function)new Function<BatchHandle, BatchDatabase>(){

            public BatchDatabase apply(BatchHandle batchHandle) {
                return new DatabaseImpl(parentFullName, id, schema, batchHandle);
            }
        }));
    }

    @Override
    public InputChannel<WatchChange> watch(VContext ctx, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns) {
        return InputChannels.transform(ctx, this.client.watchPatterns(ctx, resumeMarker, patterns), new InputChannels.TransformFunction<Change, WatchChange>(){

            @Override
            public WatchChange apply(Change change) throws VException {
                return DatabaseImpl.this.convertToWatchChange(change);
            }
        });
    }

    @Override
    public InputChannel<WatchChange> watch(VContext ctx, List<CollectionRowPattern> patterns) {
        return this.watch(ctx, null, patterns);
    }

    @Override
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext ctx) {
        return this.client.getResumeMarker(ctx, this.batchHandle);
    }

    @Override
    public void listenForInvites(VContext context, Database.InviteHandler handler) throws VException {
        this.nativeListenForInvites(context, handler);
    }

    @Override
    public Syncgroup getSyncgroup(Id sgId) {
        return new SyncgroupImpl(this.fullName, sgId);
    }

    @Override
    public ListenableFuture<List<Id>> listSyncgroups(VContext ctx) {
        return this.client.listSyncgroups(ctx);
    }

    @Override
    public ListenableFuture<BlobWriter> writeBlob(VContext ctx, BlobRef ref) {
        ListenableFuture<BlobRef> refFuture = ref == null ? this.client.createBlob(ctx) : Futures.immediateFuture((Object)ref);
        return VFutures.withUserLandChecks(ctx, Futures.transform(refFuture, (Function)new Function<BlobRef, BlobWriter>(){

            public BlobWriter apply(BlobRef ref) {
                return new BlobWriterImpl(DatabaseImpl.this.client, ref);
            }
        }));
    }

    @Override
    public BlobReader readBlob(VContext ctx, BlobRef ref) throws VException {
        if (ref == null) {
            throw new VException("Must pass a non-null blob ref.");
        }
        return new BlobReaderImpl(this.client, ref);
    }

    @Override
    public ListenableFuture<Void> enforceSchema(VContext ctx) {
        ListenableFutureCallback callback = new ListenableFutureCallback();
        NotImplementedException error = new NotImplementedException(ctx);
        callback.onFailure(error);
        return callback.getFuture(ctx);
    }

    @Override
    public ListenableFuture<Void> commit(VContext ctx) {
        return this.client.commit(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<Void> abort(VContext ctx) {
        return this.client.abort(ctx, this.batchHandle);
    }

    private WatchChange convertToWatchChange(Change watchChange) throws VException {
        ChangeType changeType;
        Object value = watchChange.getValue().getElem();
        if (!(value instanceof StoreChange)) {
            throw new VException("Expected watch data to contain StoreChange, instead got: " + value);
        }
        StoreChange storeChange = (StoreChange)value;
        switch (watchChange.getState()) {
            case 0: {
                changeType = ChangeType.PUT_CHANGE;
                break;
            }
            case 1: {
                changeType = ChangeType.DELETE_CHANGE;
                break;
            }
            default: {
                throw new VException("Unsupported watch change state: " + watchChange.getState());
            }
        }
        String[] parts = watchChange.getName().split("/", 2);
        if (parts.length != 2) {
            throw new VException("Invalid collection-row pair: " + watchChange.getName());
        }
        Id collectionId = Util.decodeId(parts[0]);
        String rowName = parts[1];
        return new WatchChange(collectionId, rowName, changeType, storeChange.getValue(), watchChange.getResumeMarker(), storeChange.getFromSync(), watchChange.getContinued());
    }

    private ListenableFuture<DatabaseCore.QueryResults> execInternal(VContext ctx, String query, List<VdlAny> params) {
        final ClientRecvStream<List<VdlAny>, Void> stream = this.client.exec(ctx, this.batchHandle, query, params);
        return VFutures.withUserLandChecks(ctx, Futures.transform(stream.recv(), (AsyncFunction)new AsyncFunction<List<VdlAny>, DatabaseCore.QueryResults>(){

            public ListenableFuture<DatabaseCore.QueryResults> apply(List<VdlAny> columnNames) throws Exception {
                return Futures.immediateFuture((Object)new QueryResultsImpl(columnNames, stream));
            }
        }));
    }

    private static class QueryResultsImpl
    implements DatabaseCore.QueryResults {
        private final InputChannel<List<VdlAny>> input;
        private final List<String> columnNames;

        private QueryResultsImpl(List<VdlAny> columnNames, InputChannel<List<VdlAny>> input) throws VException {
            this.input = input;
            this.columnNames = new ArrayList<String>(columnNames.size());
            for (int i = 0; i < columnNames.size(); ++i) {
                Object elem = columnNames.get(i).getElem();
                if (!(elem instanceof String)) {
                    throw new VException("Expected first row in exec() stream to contain column names (of type String), got type: " + elem.getClass());
                }
                this.columnNames.add((String)elem);
            }
        }

        @Override
        public ListenableFuture<List<VdlAny>> recv() {
            return this.input.recv();
        }

        @Override
        public List<String> columnNames() {
            return this.columnNames;
        }
    }
}

