/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.impl.google.naming.NamingUtil;
import io.v.v23.InputChannel;
import io.v.v23.context.VContext;
import io.v.v23.security.BlessingPattern;
import io.v.v23.security.access.AccessList;
import io.v.v23.security.access.Constants;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.CollectionClient;
import io.v.v23.services.syncbase.CollectionClientFactory;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.KeyValue;
import io.v.v23.syncbase.Collection;
import io.v.v23.syncbase.Row;
import io.v.v23.syncbase.RowImpl;
import io.v.v23.syncbase.RowRange;
import io.v.v23.syncbase.util.Util;
import java.util.List;
import java.util.Map;

class CollectionImpl
implements Collection {
    private final String fullName;
    private final Id id;
    private final BatchHandle batchHandle;
    private final CollectionClient client;

    CollectionImpl(String parentFullName, Id id, BatchHandle batchHandle) {
        this.fullName = NamingUtil.join(parentFullName, Util.encodeId(id));
        this.id = id;
        this.batchHandle = batchHandle;
        this.client = CollectionClientFactory.getCollectionClient(this.fullName);
    }

    @Override
    public Id id() {
        return this.id;
    }

    @Override
    public String fullName() {
        return this.fullName;
    }

    @Override
    public ListenableFuture<Void> create(VContext ctx, Permissions perms) {
        if (perms == null) {
            String blessing = Util.UserBlessingFromContext(ctx);
            AccessList acl = new AccessList((List<BlessingPattern>)ImmutableList.of((Object)new BlessingPattern(blessing)), (List<String>)ImmutableList.of());
            perms = new Permissions((Map<String, AccessList>)ImmutableMap.of((Object)Constants.READ.getValue(), (Object)acl, (Object)Constants.WRITE.getValue(), (Object)acl, (Object)Constants.ADMIN.getValue(), (Object)acl));
        }
        return this.client.create(ctx, this.batchHandle, perms);
    }

    @Override
    public ListenableFuture<Void> destroy(VContext ctx) {
        return this.client.destroy(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<Boolean> exists(VContext ctx) {
        return this.client.exists(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<Permissions> getPermissions(VContext ctx) {
        return this.client.getPermissions(ctx, this.batchHandle);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext ctx, Permissions perms) {
        return this.client.setPermissions(ctx, this.batchHandle, perms);
    }

    @Override
    public Row getRow(String key) {
        return new RowImpl(this.fullName, key, this.batchHandle);
    }

    @Override
    public <T> ListenableFuture<T> get(VContext ctx, String key, Class<T> clazz) {
        return this.getRow(key).get(ctx, clazz);
    }

    @Override
    public ListenableFuture<Void> put(VContext ctx, String key, Object value) {
        return this.getRow(key).put(ctx, value);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx, String key) {
        return this.getRow(key).delete(ctx);
    }

    @Override
    public ListenableFuture<Void> deleteRange(VContext ctx, RowRange range) {
        return this.client.deleteRange(ctx, this.batchHandle, Util.getBytes(range.getStart()), Util.getBytes(range.getLimit()));
    }

    @Override
    public InputChannel<KeyValue> scan(VContext ctx, RowRange range) {
        return this.client.scan(ctx, this.batchHandle, Util.getBytes(range.getStart()), Util.getBytes(range.getLimit()));
    }
}

