/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.DatabaseClient;
import io.v.v23.syncbase.BlobWriter;
import io.v.v23.vdl.ClientSendStream;
import io.v.v23.verror.VException;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BlobWriterImpl
implements BlobWriter {
    private final DatabaseClient client;
    private final BlobRef ref;

    BlobWriterImpl(DatabaseClient client, BlobRef ref) {
        this.client = client;
        this.ref = ref;
    }

    @Override
    public BlobRef getRef() {
        return this.ref;
    }

    @Override
    public OutputStream stream(VContext ctx) {
        return new BufferedOutputStream(new BlobOutputStream(this.client.putBlob(ctx, this.ref)), 16384);
    }

    @Override
    public ListenableFuture<Void> commit(VContext ctx) {
        return this.client.commitBlob(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Long> size(VContext ctx) {
        return this.client.getBlobSize(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx) {
        return this.client.deleteBlob(ctx, this.ref);
    }

    private static class BlobOutputStream
    extends OutputStream {
        private final ClientSendStream<byte[], Void> stream;
        private boolean closed = false;

        BlobOutputStream(ClientSendStream<byte[], Void> stream) {
            this.stream = stream;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                VFutures.sync(this.stream.finish());
                this.closed = true;
            }
            catch (VException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] copy = new byte[len];
            System.arraycopy(b, off, copy, 0, len);
            this.write(copy);
        }

        @Override
        public void write(byte[] b) throws IOException {
            try {
                VFutures.sync(this.stream.send(b));
            }
            catch (VException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }
    }
}

