/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.InputChannel;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.services.syncbase.BlobFetchStatus;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.DatabaseClient;
import io.v.v23.syncbase.BlobReader;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.verror.EndOfFileException;
import io.v.v23.verror.VException;
import java.io.IOException;
import java.io.InputStream;

class BlobReaderImpl
implements BlobReader {
    private final DatabaseClient client;
    private final BlobRef ref;

    BlobReaderImpl(DatabaseClient client, BlobRef ref) {
        this.client = client;
        this.ref = ref;
    }

    @Override
    public BlobRef getRef() {
        return this.ref;
    }

    @Override
    public InputStream stream(VContext ctx, long offset) {
        return new BlobInputStream(this.client.getBlob(ctx, this.ref, offset));
    }

    @Override
    public InputChannel<BlobFetchStatus> prefetch(VContext ctx, long priority) {
        return this.client.fetchBlob(ctx, this.ref, new VdlUint64(priority));
    }

    @Override
    public ListenableFuture<Long> size(VContext ctx) {
        return this.client.getBlobSize(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Void> delete(VContext ctx) {
        return this.client.deleteBlob(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Void> pin(VContext ctx) {
        return this.client.pinBlob(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Void> unpin(VContext ctx) {
        return this.client.unpinBlob(ctx, this.ref);
    }

    @Override
    public ListenableFuture<Void> keep(VContext ctx, long rank) {
        return this.client.keepBlob(ctx, this.ref, new VdlUint64(rank));
    }

    private static class BlobInputStream
    extends InputStream {
        private final ClientRecvStream<byte[], Void> stream;
        private boolean closed = false;
        private byte[] lastRecv = null;
        private int lastRecvRemaining = 0;
        private boolean eof = false;

        BlobInputStream(ClientRecvStream<byte[], Void> stream) {
            this.stream = stream;
        }

        @Override
        public int available() {
            return 0;
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                VFutures.sync(this.stream.finish());
                this.closed = true;
            }
            catch (VException e) {
                throw new IOException(e);
            }
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public synchronized int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == -1) {
                return -1;
            }
            return b[0];
        }

        @Override
        public synchronized int read(byte[] b, int offset, int len) throws IOException {
            int need;
            int copyLen;
            if (this.closed) {
                throw new IOException("Stream closed");
            }
            if (this.eof) {
                return -1;
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || len < 0 || len > b.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (need = len; need > 0; need -= copyLen) {
                if (this.lastRecvRemaining <= 0) {
                    try {
                        this.lastRecv = (byte[])VFutures.sync(this.stream.recv());
                        this.lastRecvRemaining = this.lastRecv.length;
                    }
                    catch (EndOfFileException e) {
                        this.eof = true;
                        break;
                    }
                    catch (VException e) {
                        throw new IOException(e);
                    }
                }
                copyLen = len > this.lastRecvRemaining ? this.lastRecvRemaining : len;
                System.arraycopy(this.lastRecv, this.lastRecv.length - this.lastRecvRemaining, b, offset + len - need, copyLen);
                this.lastRecvRemaining -= copyLen;
            }
            if (need == len) {
                return -1;
            }
            return len - need;
        }

        @Override
        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }
    }
}

