/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.syncbase;

import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.services.syncbase.BatchOptions;
import io.v.v23.services.syncbase.ConcurrentBatchException;
import io.v.v23.syncbase.BatchDatabase;
import io.v.v23.syncbase.Database;
import javax.annotation.CheckReturnValue;

public class Batch {
    @CheckReturnValue
    public static ListenableFuture<Void> runInBatch(VContext context, Database db, BatchOptions opts, BatchOperation op) {
        return VFutures.withUserLandChecks(context, Futures.transform((ListenableFuture)Futures.immediateFuture((Object)false), Batch.getRetryFn(context, db, opts, op, 0)));
    }

    private static AsyncFunction<Boolean, Void> getRetryFn(final VContext ctx, final Database db, final BatchOptions opts, final BatchOperation op, final int round) {
        return new AsyncFunction<Boolean, Void>(){

            public ListenableFuture<Void> apply(Boolean success) throws Exception {
                if (success.booleanValue()) {
                    return Futures.immediateFuture(null);
                }
                if (round >= 3) {
                    throw new ConcurrentBatchException(ctx);
                }
                return Futures.transform((ListenableFuture)Batch.tryBatch(ctx, db, opts, op), (AsyncFunction)Batch.getRetryFn(ctx, db, opts, op, round + 1));
            }
        };
    }

    @CheckReturnValue
    private static ListenableFuture<Boolean> tryBatch(final VContext ctx, Database db, final BatchOptions opts, final BatchOperation op) {
        final SettableFuture ret = SettableFuture.create();
        Futures.addCallback(db.beginBatch(ctx, opts), (FutureCallback)new FutureCallback<BatchDatabase>(){

            public void onFailure(Throwable t) {
                ret.setException(t);
            }

            public void onSuccess(final BatchDatabase batch) {
                Futures.addCallback(op.run(batch), (FutureCallback)new FutureCallback<Void>(){

                    public void onFailure(final Throwable t) {
                        Futures.addCallback(batch.abort(ctx), (FutureCallback)new FutureCallback<Void>(){

                            public void onSuccess(Void result) {
                                ret.setException(t);
                            }

                            public void onFailure(Throwable newT) {
                                ret.setException(t);
                            }
                        });
                    }

                    public void onSuccess(Void result) {
                        Futures.addCallback(opts.getReadOnly() ? batch.abort(ctx) : batch.commit(ctx), (FutureCallback)new FutureCallback<Void>(){

                            public void onSuccess(Void result) {
                                ret.set((Object)true);
                            }

                            public void onFailure(Throwable t) {
                                if (t instanceof ConcurrentBatchException) {
                                    ret.set((Object)false);
                                } else {
                                    ret.setException(t);
                                }
                            }
                        });
                    }
                });
            }
        });
        return ret;
    }

    public static interface BatchOperation {
        @CheckReturnValue
        public ListenableFuture<Void> run(BatchDatabase var1);
    }
}

