/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SyncgroupManagerServer;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.services.syncbase.SyncgroupSpec;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class SyncgroupManagerServerWrapper {
    private final SyncgroupManagerServer server;

    public SyncgroupManagerServerWrapper(SyncgroupManagerServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<Id>>(){}.getType())));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("listSyncgroups", "// ListSyncgroups returns the relative syncgroup ids of all syncgroups attached to// this database.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupSpec.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupMemberInfo.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("createSyncgroup", "// CreateSyncgroup creates a new syncgroup with the given spec.//// Requires: Client must have at least Read access on the Database; all// Collections specified in prefixes must exist; Client must have at least// Read access on each of the Collection ACLs.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupMemberInfo.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupSpec.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("joinSyncgroup", "// JoinSyncgroup joins the syncgroup.//// Requires: Client must have at least Read access on the Database and on the// syncgroup ACL.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("leaveSyncgroup", "// LeaveSyncgroup leaves the syncgroup. Previously synced data will continue// to be available.//// Requires: Client must have at least Read access on the Database.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("destroySyncgroup", "// DestroySyncgroup destroys the syncgroup. Previously synced data will// continue to be available to all members.//// Requires: Client must have at least Read access on the Database, and must// have Admin access on the syncgroup ACL.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("ejectFromSyncgroup", "// EjectFromSyncgroup ejects a member from the syncgroup. The ejected member// will not be able to sync further, but will retain any data it has already// synced.//// Requires: Client must have at least Read access on the Database, and must// have Admin access on the syncgroup ACL.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupSpec.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getSyncgroupSpec", "// GetSyncgroupSpec gets the syncgroup spec. version allows for atomic// read-modify-write of the spec - see comment for SetSyncgroupSpec.//// Requires: Client must have at least Read access on the Database and on the// syncgroup ACL.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SyncgroupSpec.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("setSyncgroupSpec", "// SetSyncgroupSpec sets the syncgroup spec. version may be either empty or// the value from a previous Get. If not empty, Set will only succeed if the// current version matches the specified one.//// Requires: Client must have at least Read access on the Database, and must// have Admin access on the syncgroup ACL.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Id.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Map<String, SyncgroupMemberInfo>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getSyncgroupMembers", "// GetSyncgroupMembers gets the info objects for members of the syncgroup.//// Requires: Client must have at least Read access on the Database and on the// syncgroup ACL.", inArgs, outArgs, null, null, tags));
        return new Interface("SyncgroupManager", "io.v.v23.services.syncbase", "// SyncgroupManager is the interface for syncgroup operations.// TODO(hpucha): Add blessings to create/join and add a refresh method.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("createSyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"createSyncgroup\": %s", e.getMessage()));
            }
        }
        if ("destroySyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"destroySyncgroup\": %s", e.getMessage()));
            }
        }
        if ("ejectFromSyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"ejectFromSyncgroup\": %s", e.getMessage()));
            }
        }
        if ("getSyncgroupMembers".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getSyncgroupMembers\": %s", e.getMessage()));
            }
        }
        if ("getSyncgroupSpec".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getSyncgroupSpec\": %s", e.getMessage()));
            }
        }
        if ("joinSyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"joinSyncgroup\": %s", e.getMessage()));
            }
        }
        if ("leaveSyncgroup".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"leaveSyncgroup\": %s", e.getMessage()));
            }
        }
        if ("listSyncgroups".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"listSyncgroups\": %s", e.getMessage()));
            }
        }
        if ("setSyncgroupSpec".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"setSyncgroupSpec\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<List<Id>> listSyncgroups(VContext _ctx, StreamServerCall _call) {
        return this.server.listSyncgroups(_ctx, _call);
    }

    public ListenableFuture<Void> createSyncgroup(VContext _ctx, StreamServerCall _call, Id sgId, SyncgroupSpec spec, SyncgroupMemberInfo myInfo) {
        return this.server.createSyncgroup(_ctx, _call, sgId, spec, myInfo);
    }

    public ListenableFuture<SyncgroupSpec> joinSyncgroup(VContext _ctx, StreamServerCall _call, String remoteSyncbaseName, List<String> expectedSyncbaseBlessings, Id sgId, SyncgroupMemberInfo myInfo) {
        return this.server.joinSyncgroup(_ctx, _call, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
    }

    public ListenableFuture<Void> leaveSyncgroup(VContext _ctx, StreamServerCall _call, Id sgId) {
        return this.server.leaveSyncgroup(_ctx, _call, sgId);
    }

    public ListenableFuture<Void> destroySyncgroup(VContext _ctx, StreamServerCall _call, Id sgId) {
        return this.server.destroySyncgroup(_ctx, _call, sgId);
    }

    public ListenableFuture<Void> ejectFromSyncgroup(VContext _ctx, StreamServerCall _call, Id sgId, String member) {
        return this.server.ejectFromSyncgroup(_ctx, _call, sgId, member);
    }

    public ListenableFuture<SyncgroupManagerServer.GetSyncgroupSpecOut> getSyncgroupSpec(VContext _ctx, StreamServerCall _call, Id sgId) {
        return this.server.getSyncgroupSpec(_ctx, _call, sgId);
    }

    public ListenableFuture<Void> setSyncgroupSpec(VContext _ctx, StreamServerCall _call, Id sgId, SyncgroupSpec spec, String version) {
        return this.server.setSyncgroupSpec(_ctx, _call, sgId, spec, version);
    }

    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getSyncgroupMembers(VContext _ctx, StreamServerCall _call, Id sgId) {
        return this.server.getSyncgroupMembers(_ctx, _call, sgId);
    }
}

