/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.syncbase.DevModeUpdateVClockOpts;
import io.v.v23.services.syncbase.ServiceServer;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.joda.time.DateTime;

public final class ServiceServerWrapper {
    private final ServiceServer server;
    private final ObjectServerWrapper wrapperObject;

    public ServiceServerWrapper(ServiceServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)DevModeUpdateVClockOpts.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("devModeUpdateVClock", "// DevModeUpdateVClock updates various bits of Syncbase virtual clock and// clock daemon state based on the specified options.// Requires --dev flag to be set (in addition to Admin check).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)DateTime.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("devModeGetTime", "// DevModeGetTime returns the current time per the Syncbase clock.// Requires --dev flag to be set (in addition to Admin check).", inArgs, outArgs, null, null, tags));
        return new Interface("Service", "io.v.v23.services.syncbase", "// Service represents a Vanadium Syncbase service.// Service.Glob operates over Database ids.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("devModeGetTime".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"devModeGetTime\": %s", e.getMessage()));
            }
        }
        if ("devModeUpdateVClock".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"devModeUpdateVClock\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> devModeUpdateVClock(VContext _ctx, StreamServerCall _call, DevModeUpdateVClockOpts uco) {
        return this.server.devModeUpdateVClock(_ctx, _call, uco);
    }

    public ListenableFuture<DateTime> devModeGetTime(VContext _ctx, StreamServerCall _call) {
        return this.server.devModeGetTime(_ctx, _call);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }
}

