/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.SchemaManagerServer;
import io.v.v23.services.syncbase.SchemaMetadata;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class SchemaManagerServerWrapper {
    private final SchemaManagerServer server;

    public SchemaManagerServerWrapper(SchemaManagerServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SchemaMetadata.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getSchemaMetadata", "// GetSchemaMetadata retrieves schema metadata for this database.//// Requires: Client must have at least Read access on the Database.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)SchemaMetadata.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("setSchemaMetadata", "// SetSchemaMetadata stores schema metadata for this database.//// Requires: Client must have at least Write access on the Database.", inArgs, outArgs, null, null, tags));
        return new Interface("SchemaManager", "io.v.v23.services.syncbase", "// SchemaManager implements the API for managing schema metadata attached// to a Database.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("getSchemaMetadata".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getSchemaMetadata\": %s", e.getMessage()));
            }
        }
        if ("setSchemaMetadata".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"setSchemaMetadata\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<SchemaMetadata> getSchemaMetadata(VContext _ctx, StreamServerCall _call) {
        return this.server.getSchemaMetadata(_ctx, _call);
    }

    public ListenableFuture<Void> setSchemaMetadata(VContext _ctx, StreamServerCall _call, SchemaMetadata metadata) {
        return this.server.setSchemaMetadata(_ctx, _call, metadata);
    }
}

