/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.RowServer;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class RowServerWrapper {
    private final RowServer server;

    public RowServerWrapper(RowServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("exists", "// Exists returns true only if this Row exists. Insufficient permissions// cause Exists to return false instead of an error.// Note, Exists on Row requires read permissions, unlike higher levels of// hierarchy which require resolve, because Row existence usually carries// more information.// TODO(ivanpi): Exists may fail with an error if higher levels of hierarchy// do not exist.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlAny.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("get", "// Get returns the value for this Row.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlAny.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("put", "// Put writes the given value for this Row.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("delete", "// Delete deletes this Row.", inArgs, outArgs, null, null, tags));
        return new Interface("Row", "io.v.v23.services.syncbase", "// Row represents a single row in a Collection.// All access checks are performed against the Collection ACL.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("delete".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
            }
        }
        if ("exists".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"exists\": %s", e.getMessage()));
            }
        }
        if ("get".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"get\": %s", e.getMessage()));
            }
        }
        if ("put".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"put\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Boolean> exists(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.exists(_ctx, _call, bh);
    }

    public ListenableFuture<VdlAny> get(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.get(_ctx, _call, bh);
    }

    public ListenableFuture<Void> put(VContext _ctx, StreamServerCall _call, BatchHandle bh, VdlAny value) {
        return this.server.put(_ctx, _call, bh, value);
    }

    public ListenableFuture<Void> delete(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.delete(_ctx, _call, bh);
    }
}

