/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.DatabaseWatcherServer;
import io.v.v23.services.watch.Change;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherServerWrapper;
import io.v.v23.services.watch.ResumeMarker;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class DatabaseWatcherServerWrapper {
    private final DatabaseWatcherServer server;
    private final GlobWatcherServerWrapper wrapperGlobWatcher;

    public DatabaseWatcherServerWrapper(DatabaseWatcherServer server) {
        this.server = server;
        this.wrapperGlobWatcher = new GlobWatcherServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<ResumeMarker>(){}.getType())));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getResumeMarker", "// GetResumeMarker returns the ResumeMarker that points to the current end// of the event log. GetResumeMarker() can be called on a batch.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<ResumeMarker>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<CollectionRowPattern>>(){}.getType())));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("watchPatterns", "// WatchPatterns returns a stream of changes that match any of the specified// patterns. At least one pattern must be specified.", inArgs, outArgs, null, null, tags));
        return new Interface("DatabaseWatcher", "io.v.v23.services.syncbase", "// DatabaseWatcher allows a client to watch for updates to the database. For// each watch request, the client will receive a reliable stream of watch events// without re-ordering. Only rows and collections matching at least one of the// patterns are returned. Rows in collections with no Read access are also// filtered out.//// Watching is done by starting a streaming RPC. The RPC takes a ResumeMarker// argument that points to a particular place in the database event log. If an// empty ResumeMarker is provided, the WatchStream will begin with a Change// batch containing the initial state, always starting with an empty update for// the root entity. Otherwise, the WatchStream will contain only changes since// the provided ResumeMarker.// See watch.GlobWatcher for a detailed explanation of the behavior.//// The result stream consists of a never-ending sequence of Change messages// (until the call fails or is canceled). Each Change contains the Name field// with the Vanadium name of the watched entity relative to the database:// - \"<encCxId>/<rowKey>\" for row updates// - \"<encCxId>\" for collection updates// - \"\" for the initial root entity update// The Value field is a StoreChange.// If the client has no access to a row specified in a change, that change is// excluded from the result stream.//// Note: A single Watch Change batch may contain changes from more than one// batch as originally committed on a remote Syncbase or obtained from conflict// resolution. However, changes from a single original batch will always appear// in the same Change batch.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("getResumeMarker".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getResumeMarker\": %s", e.getMessage()));
            }
        }
        if ("watchPatterns".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"watchPatterns\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperGlobWatcher.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.getResumeMarker(_ctx, _call, bh);
    }

    public ListenableFuture<Void> watchPatterns(VContext _ctx, final StreamServerCall _call, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns) {
        ServerStream<Change, Void> _stream = new ServerStream<Change, Void>(){

            @Override
            public ListenableFuture<Void> send(Change _item) {
                Class<Change> _type = Change.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.watchPatterns(_ctx, _call, resumeMarker, patterns, (ServerSendStream<Change>)_stream);
    }

    public ListenableFuture<Void> watchGlob(VContext ctx, StreamServerCall call, GlobRequest req) throws VException {
        return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
    }
}

