/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.DatabaseWatcherClient;
import io.v.v23.services.watch.Change;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherClient;
import io.v.v23.services.watch.GlobWatcherClientFactory;
import io.v.v23.services.watch.ResumeMarker;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientStream;
import java.lang.reflect.Type;
import java.util.List;

final class DatabaseWatcherClientImpl
implements DatabaseWatcherClient {
    private final Client client;
    private final String vName;
    private final GlobWatcherClient implGlobWatcher;

    public DatabaseWatcherClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implGlobWatcher = GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh) {
        return this.getResumeMarker(_context, bh, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh, Options _opts) {
        return this.getResumeMarker(_context, bh, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh, RpcOptions _opts) {
        Object[] _args = new Object[]{bh};
        Type[] _argTypes = new Type[]{BatchHandle.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "getResumeMarker", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, ResumeMarker>(){

            public ListenableFuture<ResumeMarker> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{new TypeToken<ResumeMarker>(){}.getType()};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], ResumeMarker>(){

                    public ResumeMarker apply(Object[] _results) {
                        return (ResumeMarker)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<Change, Void> watchPatterns(VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns) {
        return this.watchPatterns(_context, resumeMarker, patterns, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Change, Void> watchPatterns(VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns, Options _opts) {
        return this.watchPatterns(_context, resumeMarker, patterns, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<Change, Void> watchPatterns(final VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns, RpcOptions _opts) {
        Object[] _args = new Object[]{resumeMarker, patterns};
        Type[] _argTypes = new Type[]{new TypeToken<ResumeMarker>(){}.getType(), new TypeToken<List<CollectionRowPattern>>(){}.getType()};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "watchPatterns", _args, _argTypes, _opts);
        return new ClientStream<Void, Change, Void>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<Change> recv() {
                final Class<Change> recvType = Change.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Change>(){

                    public ListenableFuture<Change> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, Change>(){

                            public Change apply(Object result) {
                                return (Change)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req) {
        return this.implGlobWatcher.watchGlob(_context, req);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, Options _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, RpcOptions _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }
}

