/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.BatchOptions;
import io.v.v23.services.syncbase.BlobManagerServerWrapper;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.ConflictManagerServerWrapper;
import io.v.v23.services.syncbase.DatabaseServer;
import io.v.v23.services.syncbase.DatabaseWatcherServerWrapper;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.SchemaManagerServerWrapper;
import io.v.v23.services.syncbase.SchemaMetadata;
import io.v.v23.services.syncbase.SyncgroupManagerServer;
import io.v.v23.services.syncbase.SyncgroupManagerServerWrapper;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.services.syncbase.SyncgroupSpec;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherServerWrapper;
import io.v.v23.services.watch.ResumeMarker;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class DatabaseServerWrapper {
    private final DatabaseServer server;
    private final ObjectServerWrapper wrapperObject;
    private final GlobWatcherServerWrapper wrapperGlobWatcher;
    private final DatabaseWatcherServerWrapper wrapperDatabaseWatcher;
    private final SyncgroupManagerServerWrapper wrapperSyncgroupManager;
    private final BlobManagerServerWrapper wrapperBlobManager;
    private final SchemaManagerServerWrapper wrapperSchemaManager;
    private final ConflictManagerServerWrapper wrapperConflictManager;

    public DatabaseServerWrapper(DatabaseServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
        this.wrapperGlobWatcher = new GlobWatcherServerWrapper(server);
        this.wrapperDatabaseWatcher = new DatabaseWatcherServerWrapper(server);
        this.wrapperSyncgroupManager = new SyncgroupManagerServerWrapper(server);
        this.wrapperBlobManager = new BlobManagerServerWrapper(server);
        this.wrapperSchemaManager = new SchemaManagerServerWrapper(server);
        this.wrapperConflictManager = new ConflictManagerServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<VdlOptional<SchemaMetadata>>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("create", "// Create creates this Database. Permissions must be non-nil and include at// least one admin.// Create requires the caller to have Write permission at the Service.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("destroy", "// Destroy destroys this Database, permanently removing all of its data.// TODO(sadovsky): Specify what happens to syncgroups.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Resolve"), Tag.class)));
        methods.add(new Method("exists", "// Exists returns true only if this Database exists. Insufficient permissions// cause Exists to return false instead of an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<Id>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("listCollections", "// ListCollections returns an unsorted list of all Collection ids that the// caller is allowed to see.// This method exists on Database but not on Service because for the latter// we can simply use glob, while for the former glob lists only Collections// visible in a new snapshot of the Database, ignoring user batches.// (Note that the same issue is present in glob on Collection, where Scan can// be used instead if batch awareness is required.)// Note, the glob client library checks Resolve access on every component// along the path (by doing a Dispatcher.Lookup), whereas this doesn't happen// for other RPCs.// TODO(ivanpi): Resolve should be checked on all RPCs.// TODO(sadovsky): Maybe switch to streaming RPC.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<VdlAny>>(){}.getType())));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("exec", "// Exec executes a syncQL query with positional parameters and returns all// results as specified by the query's select/delete statement.// Concurrency semantics are documented in model.go.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchOptions.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("beginBatch", "// BeginBatch creates a new batch. It returns a batch handle to pass in when// calling batch-aware RPCs.// Concurrency semantics are documented in model.go.// All batch-aware RPCs can also be called outside a batch (with an empty// handle), with the exception of Commit and Abort which only make sense on// a batch. Note that glob RPCs are not batch-aware.// TODO(sadovsky): Maybe make BatchOptions optional. Also, rename 'bo' to// 'opts' once v.io/i/912 is resolved for Java.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("commit", "// Commit persists the pending changes to the database.// If the batch is readonly, Commit() will fail with ErrReadOnlyBatch; Abort()// should be used instead.// If the BatchHandle is empty, Commit() will fail with ErrNotBoundToBatch.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("abort", "// Abort notifies the server that any pending changes can be discarded.// It is not strictly required, but it may allow the server to release locks// or other resources sooner than if it was not called.// If the BatchHandle is empty, Abort() will fail with ErrNotBoundToBatch.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("pauseSync", "// PauseSync pauses sync for this database. Incoming sync, as well as outgoing// sync of subsequent writes, will be disabled until ResumeSync is called.// PauseSync is idempotent.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("resumeSync", "// ResumeSync resumes sync for this database. ResumeSync is idempotent.", inArgs, outArgs, null, null, tags));
        return new Interface("Database", "io.v.v23.services.syncbase", "// Database represents a set of Collections. Batches, queries, syncgroups, and// watch all operate at the Database level.// Database.Glob operates over Collection ids.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("abort".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"abort\": %s", e.getMessage()));
            }
        }
        if ("beginBatch".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"beginBatch\": %s", e.getMessage()));
            }
        }
        if ("commit".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"commit\": %s", e.getMessage()));
            }
        }
        if ("create".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
            }
        }
        if ("destroy".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"destroy\": %s", e.getMessage()));
            }
        }
        if ("exec".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"exec\": %s", e.getMessage()));
            }
        }
        if ("exists".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Resolve"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"exists\": %s", e.getMessage()));
            }
        }
        if ("listCollections".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"listCollections\": %s", e.getMessage()));
            }
        }
        if ("pauseSync".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"pauseSync\": %s", e.getMessage()));
            }
        }
        if ("resumeSync".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"resumeSync\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperGlobWatcher.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperDatabaseWatcher.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperSyncgroupManager.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperBlobManager.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperSchemaManager.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperConflictManager.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> create(VContext _ctx, StreamServerCall _call, VdlOptional<SchemaMetadata> metadata, Permissions perms) {
        return this.server.create(_ctx, _call, metadata, perms);
    }

    public ListenableFuture<Void> destroy(VContext _ctx, StreamServerCall _call) {
        return this.server.destroy(_ctx, _call);
    }

    public ListenableFuture<Boolean> exists(VContext _ctx, StreamServerCall _call) {
        return this.server.exists(_ctx, _call);
    }

    public ListenableFuture<List<Id>> listCollections(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.listCollections(_ctx, _call, bh);
    }

    public ListenableFuture<Void> exec(VContext _ctx, final StreamServerCall _call, BatchHandle bh, String query, List<VdlAny> params) {
        ServerStream<List<VdlAny>, Void> _stream = new ServerStream<List<VdlAny>, Void>(){

            @Override
            public ListenableFuture<Void> send(List<VdlAny> _item) {
                Type _type = new TypeToken<List<VdlAny>>(){}.getType();
                return _call.send(_item, _type);
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.exec(_ctx, _call, bh, query, params, (ServerSendStream<List<VdlAny>>)_stream);
    }

    public ListenableFuture<BatchHandle> beginBatch(VContext _ctx, StreamServerCall _call, BatchOptions bo) {
        return this.server.beginBatch(_ctx, _call, bo);
    }

    public ListenableFuture<Void> commit(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.commit(_ctx, _call, bh);
    }

    public ListenableFuture<Void> abort(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.abort(_ctx, _call, bh);
    }

    public ListenableFuture<Void> pauseSync(VContext _ctx, StreamServerCall _call) {
        return this.server.pauseSync(_ctx, _call);
    }

    public ListenableFuture<Void> resumeSync(VContext _ctx, StreamServerCall _call) {
        return this.server.resumeSync(_ctx, _call);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }

    public ListenableFuture<Void> commitBlob(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.commitBlob(ctx, call, br);
    }

    public ListenableFuture<BlobRef> createBlob(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperBlobManager.createBlob(ctx, call);
    }

    public ListenableFuture<Void> deleteBlob(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.deleteBlob(ctx, call, br);
    }

    public ListenableFuture<Void> fetchBlob(VContext ctx, StreamServerCall call, BlobRef br, VdlUint64 priority) throws VException {
        return this.wrapperBlobManager.fetchBlob(ctx, call, br, priority);
    }

    public ListenableFuture<Long> getBlobSize(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.getBlobSize(ctx, call, br);
    }

    public ListenableFuture<Void> getBlob(VContext ctx, StreamServerCall call, BlobRef br, long offset) throws VException {
        return this.wrapperBlobManager.getBlob(ctx, call, br, offset);
    }

    public ListenableFuture<Void> keepBlob(VContext ctx, StreamServerCall call, BlobRef br, VdlUint64 rank) throws VException {
        return this.wrapperBlobManager.keepBlob(ctx, call, br, rank);
    }

    public ListenableFuture<Void> pinBlob(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.pinBlob(ctx, call, br);
    }

    public ListenableFuture<Void> putBlob(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.putBlob(ctx, call, br);
    }

    public ListenableFuture<Void> unpinBlob(VContext ctx, StreamServerCall call, BlobRef br) throws VException {
        return this.wrapperBlobManager.unpinBlob(ctx, call, br);
    }

    public ListenableFuture<Void> startConflictResolver(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperConflictManager.startConflictResolver(ctx, call);
    }

    public ListenableFuture<ResumeMarker> getResumeMarker(VContext ctx, StreamServerCall call, BatchHandle bh) throws VException {
        return this.wrapperDatabaseWatcher.getResumeMarker(ctx, call, bh);
    }

    public ListenableFuture<Void> watchPatterns(VContext ctx, StreamServerCall call, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns) throws VException {
        return this.wrapperDatabaseWatcher.watchPatterns(ctx, call, resumeMarker, patterns);
    }

    public ListenableFuture<SchemaMetadata> getSchemaMetadata(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperSchemaManager.getSchemaMetadata(ctx, call);
    }

    public ListenableFuture<Void> setSchemaMetadata(VContext ctx, StreamServerCall call, SchemaMetadata metadata) throws VException {
        return this.wrapperSchemaManager.setSchemaMetadata(ctx, call, metadata);
    }

    public ListenableFuture<Void> createSyncgroup(VContext ctx, StreamServerCall call, Id sgId, SyncgroupSpec spec, SyncgroupMemberInfo myInfo) throws VException {
        return this.wrapperSyncgroupManager.createSyncgroup(ctx, call, sgId, spec, myInfo);
    }

    public ListenableFuture<Void> destroySyncgroup(VContext ctx, StreamServerCall call, Id sgId) throws VException {
        return this.wrapperSyncgroupManager.destroySyncgroup(ctx, call, sgId);
    }

    public ListenableFuture<Void> ejectFromSyncgroup(VContext ctx, StreamServerCall call, Id sgId, String member) throws VException {
        return this.wrapperSyncgroupManager.ejectFromSyncgroup(ctx, call, sgId, member);
    }

    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getSyncgroupMembers(VContext ctx, StreamServerCall call, Id sgId) throws VException {
        return this.wrapperSyncgroupManager.getSyncgroupMembers(ctx, call, sgId);
    }

    public ListenableFuture<SyncgroupManagerServer.GetSyncgroupSpecOut> getSyncgroupSpec(VContext ctx, StreamServerCall call, Id sgId) throws VException {
        return this.wrapperSyncgroupManager.getSyncgroupSpec(ctx, call, sgId);
    }

    public ListenableFuture<SyncgroupSpec> joinSyncgroup(VContext ctx, StreamServerCall call, String remoteSyncbaseName, List<String> expectedSyncbaseBlessings, Id sgId, SyncgroupMemberInfo myInfo) throws VException {
        return this.wrapperSyncgroupManager.joinSyncgroup(ctx, call, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
    }

    public ListenableFuture<Void> leaveSyncgroup(VContext ctx, StreamServerCall call, Id sgId) throws VException {
        return this.wrapperSyncgroupManager.leaveSyncgroup(ctx, call, sgId);
    }

    public ListenableFuture<List<Id>> listSyncgroups(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperSyncgroupManager.listSyncgroups(ctx, call);
    }

    public ListenableFuture<Void> setSyncgroupSpec(VContext ctx, StreamServerCall call, Id sgId, SyncgroupSpec spec, String version) throws VException {
        return this.wrapperSyncgroupManager.setSyncgroupSpec(ctx, call, sgId, spec, version);
    }

    public ListenableFuture<Void> watchGlob(VContext ctx, StreamServerCall call, GlobRequest req) throws VException {
        return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
    }
}

