/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.BatchOptions;
import io.v.v23.services.syncbase.BlobFetchStatus;
import io.v.v23.services.syncbase.BlobManagerClient;
import io.v.v23.services.syncbase.BlobManagerClientFactory;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.services.syncbase.CollectionRowPattern;
import io.v.v23.services.syncbase.ConflictInfo;
import io.v.v23.services.syncbase.ConflictManagerClient;
import io.v.v23.services.syncbase.ConflictManagerClientFactory;
import io.v.v23.services.syncbase.DatabaseClient;
import io.v.v23.services.syncbase.DatabaseWatcherClient;
import io.v.v23.services.syncbase.DatabaseWatcherClientFactory;
import io.v.v23.services.syncbase.Id;
import io.v.v23.services.syncbase.ResolutionInfo;
import io.v.v23.services.syncbase.SchemaManagerClient;
import io.v.v23.services.syncbase.SchemaManagerClientFactory;
import io.v.v23.services.syncbase.SchemaMetadata;
import io.v.v23.services.syncbase.SyncgroupManagerClient;
import io.v.v23.services.syncbase.SyncgroupManagerClientFactory;
import io.v.v23.services.syncbase.SyncgroupMemberInfo;
import io.v.v23.services.syncbase.SyncgroupSpec;
import io.v.v23.services.watch.Change;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherClient;
import io.v.v23.services.watch.GlobWatcherClientFactory;
import io.v.v23.services.watch.ResumeMarker;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientSendStream;
import io.v.v23.vdl.ClientStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlOptional;
import io.v.v23.vdl.VdlUint64;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

final class DatabaseClientImpl
implements DatabaseClient {
    private final Client client;
    private final String vName;
    private final ObjectClient implObject;
    private final GlobWatcherClient implGlobWatcher;
    private final DatabaseWatcherClient implDatabaseWatcher;
    private final SyncgroupManagerClient implSyncgroupManager;
    private final BlobManagerClient implBlobManager;
    private final SchemaManagerClient implSchemaManager;
    private final ConflictManagerClient implConflictManager;

    public DatabaseClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implGlobWatcher = GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implDatabaseWatcher = DatabaseWatcherClientFactory.getDatabaseWatcherClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implSyncgroupManager = SyncgroupManagerClientFactory.getSyncgroupManagerClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implBlobManager = BlobManagerClientFactory.getBlobManagerClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implSchemaManager = SchemaManagerClientFactory.getSchemaManagerClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implConflictManager = ConflictManagerClientFactory.getConflictManagerClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, VdlOptional<SchemaMetadata> metadata, Permissions perms) {
        return this.create(_context, metadata, perms, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> create(VContext _context, VdlOptional<SchemaMetadata> metadata, Permissions perms, Options _opts) {
        return this.create(_context, metadata, perms, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, VdlOptional<SchemaMetadata> metadata, Permissions perms, RpcOptions _opts) {
        Object[] _args = new Object[]{metadata, perms};
        Type[] _argTypes = new Type[]{new TypeToken<VdlOptional<SchemaMetadata>>(){}.getType(), new TypeToken<Permissions>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> destroy(VContext _context) {
        return this.destroy(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> destroy(VContext _context, Options _opts) {
        return this.destroy(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> destroy(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "destroy", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Boolean> exists(VContext _context) {
        return this.exists(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Boolean> exists(VContext _context, Options _opts) {
        return this.exists(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Boolean> exists(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "exists", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Boolean>(){

            public ListenableFuture<Boolean> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Boolean.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Boolean>(){

                    public Boolean apply(Object[] _results) {
                        return (Boolean)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<List<Id>> listCollections(VContext _context, BatchHandle bh) {
        return this.listCollections(_context, bh, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<List<Id>> listCollections(VContext _context, BatchHandle bh, Options _opts) {
        return this.listCollections(_context, bh, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<List<Id>> listCollections(VContext _context, BatchHandle bh, RpcOptions _opts) {
        Object[] _args = new Object[]{bh};
        Type[] _argTypes = new Type[]{BatchHandle.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "listCollections", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, List<Id>>(){

            public ListenableFuture<List<Id>> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{new TypeToken<List<Id>>(){}.getType()};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], List<Id>>(){

                    public List<Id> apply(Object[] _results) {
                        return (List)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<List<VdlAny>, Void> exec(VContext _context, BatchHandle bh, String query, List<VdlAny> params) {
        return this.exec(_context, bh, query, params, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<List<VdlAny>, Void> exec(VContext _context, BatchHandle bh, String query, List<VdlAny> params, Options _opts) {
        return this.exec(_context, bh, query, params, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<List<VdlAny>, Void> exec(final VContext _context, BatchHandle bh, String query, List<VdlAny> params, RpcOptions _opts) {
        Object[] _args = new Object[]{bh, query, params};
        Type[] _argTypes = new Type[]{BatchHandle.class, String.class, new TypeToken<List<VdlAny>>(){}.getType()};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "exec", _args, _argTypes, _opts);
        return new ClientStream<Void, List<VdlAny>, Void>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<List<VdlAny>> recv() {
                final Type recvType = new TypeToken<List<VdlAny>>(){}.getType();
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, List<VdlAny>>(){

                    public ListenableFuture<List<VdlAny>> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, List<VdlAny>>(){

                            public List<VdlAny> apply(Object result) {
                                return (List)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<BatchHandle> beginBatch(VContext _context, BatchOptions bo) {
        return this.beginBatch(_context, bo, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<BatchHandle> beginBatch(VContext _context, BatchOptions bo, Options _opts) {
        return this.beginBatch(_context, bo, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<BatchHandle> beginBatch(VContext _context, BatchOptions bo, RpcOptions _opts) {
        Object[] _args = new Object[]{bo};
        Type[] _argTypes = new Type[]{BatchOptions.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "beginBatch", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BatchHandle>(){

            public ListenableFuture<BatchHandle> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{BatchHandle.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], BatchHandle>(){

                    public BatchHandle apply(Object[] _results) {
                        return (BatchHandle)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> commit(VContext _context, BatchHandle bh) {
        return this.commit(_context, bh, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> commit(VContext _context, BatchHandle bh, Options _opts) {
        return this.commit(_context, bh, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> commit(VContext _context, BatchHandle bh, RpcOptions _opts) {
        Object[] _args = new Object[]{bh};
        Type[] _argTypes = new Type[]{BatchHandle.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "commit", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> abort(VContext _context, BatchHandle bh) {
        return this.abort(_context, bh, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> abort(VContext _context, BatchHandle bh, Options _opts) {
        return this.abort(_context, bh, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> abort(VContext _context, BatchHandle bh, RpcOptions _opts) {
        Object[] _args = new Object[]{bh};
        Type[] _argTypes = new Type[]{BatchHandle.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "abort", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> pauseSync(VContext _context) {
        return this.pauseSync(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> pauseSync(VContext _context, Options _opts) {
        return this.pauseSync(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> pauseSync(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "pauseSync", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> resumeSync(VContext _context) {
        return this.resumeSync(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> resumeSync(VContext _context, Options _opts) {
        return this.resumeSync(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> resumeSync(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "resumeSync", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br) {
        return this.implBlobManager.commitBlob(_context, br);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.commitBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.commitBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<BlobRef> createBlob(VContext _context) {
        return this.implBlobManager.createBlob(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<BlobRef> createBlob(VContext _context, Options _opts) {
        return this.implBlobManager.createBlob(_context, _opts);
    }

    @Override
    public ListenableFuture<BlobRef> createBlob(VContext _context, RpcOptions _opts) {
        return this.implBlobManager.createBlob(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br) {
        return this.implBlobManager.deleteBlob(_context, br);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.deleteBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.deleteBlob(_context, br, _opts);
    }

    @Override
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(VContext _context, BlobRef br, VdlUint64 priority) {
        return this.implBlobManager.fetchBlob(_context, br, priority);
    }

    @Override
    @Deprecated
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(VContext _context, BlobRef br, VdlUint64 priority, Options _opts) {
        return this.implBlobManager.fetchBlob(_context, br, priority, _opts);
    }

    @Override
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(VContext _context, BlobRef br, VdlUint64 priority, RpcOptions _opts) {
        return this.implBlobManager.fetchBlob(_context, br, priority, _opts);
    }

    @Override
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br) {
        return this.implBlobManager.getBlobSize(_context, br);
    }

    @Override
    @Deprecated
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.getBlobSize(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.getBlobSize(_context, br, _opts);
    }

    @Override
    public ClientRecvStream<byte[], Void> getBlob(VContext _context, BlobRef br, long offset) {
        return this.implBlobManager.getBlob(_context, br, offset);
    }

    @Override
    @Deprecated
    public ClientRecvStream<byte[], Void> getBlob(VContext _context, BlobRef br, long offset, Options _opts) {
        return this.implBlobManager.getBlob(_context, br, offset, _opts);
    }

    @Override
    public ClientRecvStream<byte[], Void> getBlob(VContext _context, BlobRef br, long offset, RpcOptions _opts) {
        return this.implBlobManager.getBlob(_context, br, offset, _opts);
    }

    @Override
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank) {
        return this.implBlobManager.keepBlob(_context, br, rank);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank, Options _opts) {
        return this.implBlobManager.keepBlob(_context, br, rank, _opts);
    }

    @Override
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank, RpcOptions _opts) {
        return this.implBlobManager.keepBlob(_context, br, rank, _opts);
    }

    @Override
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br) {
        return this.implBlobManager.pinBlob(_context, br);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.pinBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.pinBlob(_context, br, _opts);
    }

    @Override
    public ClientSendStream<byte[], Void> putBlob(VContext _context, BlobRef br) {
        return this.implBlobManager.putBlob(_context, br);
    }

    @Override
    @Deprecated
    public ClientSendStream<byte[], Void> putBlob(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.putBlob(_context, br, _opts);
    }

    @Override
    public ClientSendStream<byte[], Void> putBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.putBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br) {
        return this.implBlobManager.unpinBlob(_context, br);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br, Options _opts) {
        return this.implBlobManager.unpinBlob(_context, br, _opts);
    }

    @Override
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        return this.implBlobManager.unpinBlob(_context, br, _opts);
    }

    @Override
    public ClientStream<ResolutionInfo, ConflictInfo, Void> startConflictResolver(VContext _context) {
        return this.implConflictManager.startConflictResolver(_context);
    }

    @Override
    @Deprecated
    public ClientStream<ResolutionInfo, ConflictInfo, Void> startConflictResolver(VContext _context, Options _opts) {
        return this.implConflictManager.startConflictResolver(_context, _opts);
    }

    @Override
    public ClientStream<ResolutionInfo, ConflictInfo, Void> startConflictResolver(VContext _context, RpcOptions _opts) {
        return this.implConflictManager.startConflictResolver(_context, _opts);
    }

    @Override
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh) {
        return this.implDatabaseWatcher.getResumeMarker(_context, bh);
    }

    @Override
    @Deprecated
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh, Options _opts) {
        return this.implDatabaseWatcher.getResumeMarker(_context, bh, _opts);
    }

    @Override
    public ListenableFuture<ResumeMarker> getResumeMarker(VContext _context, BatchHandle bh, RpcOptions _opts) {
        return this.implDatabaseWatcher.getResumeMarker(_context, bh, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchPatterns(VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns) {
        return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Change, Void> watchPatterns(VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns, Options _opts) {
        return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchPatterns(VContext _context, ResumeMarker resumeMarker, List<CollectionRowPattern> patterns, RpcOptions _opts) {
        return this.implDatabaseWatcher.watchPatterns(_context, resumeMarker, patterns, _opts);
    }

    @Override
    public ListenableFuture<SchemaMetadata> getSchemaMetadata(VContext _context) {
        return this.implSchemaManager.getSchemaMetadata(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<SchemaMetadata> getSchemaMetadata(VContext _context, Options _opts) {
        return this.implSchemaManager.getSchemaMetadata(_context, _opts);
    }

    @Override
    public ListenableFuture<SchemaMetadata> getSchemaMetadata(VContext _context, RpcOptions _opts) {
        return this.implSchemaManager.getSchemaMetadata(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setSchemaMetadata(VContext _context, SchemaMetadata metadata) {
        return this.implSchemaManager.setSchemaMetadata(_context, metadata);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setSchemaMetadata(VContext _context, SchemaMetadata metadata, Options _opts) {
        return this.implSchemaManager.setSchemaMetadata(_context, metadata, _opts);
    }

    @Override
    public ListenableFuture<Void> setSchemaMetadata(VContext _context, SchemaMetadata metadata, RpcOptions _opts) {
        return this.implSchemaManager.setSchemaMetadata(_context, metadata, _opts);
    }

    @Override
    public ListenableFuture<Void> createSyncgroup(VContext _context, Id sgId, SyncgroupSpec spec, SyncgroupMemberInfo myInfo) {
        return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> createSyncgroup(VContext _context, Id sgId, SyncgroupSpec spec, SyncgroupMemberInfo myInfo, Options _opts) {
        return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo, _opts);
    }

    @Override
    public ListenableFuture<Void> createSyncgroup(VContext _context, Id sgId, SyncgroupSpec spec, SyncgroupMemberInfo myInfo, RpcOptions _opts) {
        return this.implSyncgroupManager.createSyncgroup(_context, sgId, spec, myInfo, _opts);
    }

    @Override
    public ListenableFuture<Void> destroySyncgroup(VContext _context, Id sgId) {
        return this.implSyncgroupManager.destroySyncgroup(_context, sgId);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> destroySyncgroup(VContext _context, Id sgId, Options _opts) {
        return this.implSyncgroupManager.destroySyncgroup(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<Void> destroySyncgroup(VContext _context, Id sgId, RpcOptions _opts) {
        return this.implSyncgroupManager.destroySyncgroup(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<Void> ejectFromSyncgroup(VContext _context, Id sgId, String member) {
        return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> ejectFromSyncgroup(VContext _context, Id sgId, String member, Options _opts) {
        return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member, _opts);
    }

    @Override
    public ListenableFuture<Void> ejectFromSyncgroup(VContext _context, Id sgId, String member, RpcOptions _opts) {
        return this.implSyncgroupManager.ejectFromSyncgroup(_context, sgId, member, _opts);
    }

    @Override
    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getSyncgroupMembers(VContext _context, Id sgId) {
        return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId);
    }

    @Override
    @Deprecated
    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getSyncgroupMembers(VContext _context, Id sgId, Options _opts) {
        return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<Map<String, SyncgroupMemberInfo>> getSyncgroupMembers(VContext _context, Id sgId, RpcOptions _opts) {
        return this.implSyncgroupManager.getSyncgroupMembers(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<SyncgroupManagerClient.GetSyncgroupSpecOut> getSyncgroupSpec(VContext _context, Id sgId) {
        return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId);
    }

    @Override
    @Deprecated
    public ListenableFuture<SyncgroupManagerClient.GetSyncgroupSpecOut> getSyncgroupSpec(VContext _context, Id sgId, Options _opts) {
        return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<SyncgroupManagerClient.GetSyncgroupSpecOut> getSyncgroupSpec(VContext _context, Id sgId, RpcOptions _opts) {
        return this.implSyncgroupManager.getSyncgroupSpec(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<SyncgroupSpec> joinSyncgroup(VContext _context, String remoteSyncbaseName, List<String> expectedSyncbaseBlessings, Id sgId, SyncgroupMemberInfo myInfo) {
        return this.implSyncgroupManager.joinSyncgroup(_context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo);
    }

    @Override
    @Deprecated
    public ListenableFuture<SyncgroupSpec> joinSyncgroup(VContext _context, String remoteSyncbaseName, List<String> expectedSyncbaseBlessings, Id sgId, SyncgroupMemberInfo myInfo, Options _opts) {
        return this.implSyncgroupManager.joinSyncgroup(_context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo, _opts);
    }

    @Override
    public ListenableFuture<SyncgroupSpec> joinSyncgroup(VContext _context, String remoteSyncbaseName, List<String> expectedSyncbaseBlessings, Id sgId, SyncgroupMemberInfo myInfo, RpcOptions _opts) {
        return this.implSyncgroupManager.joinSyncgroup(_context, remoteSyncbaseName, expectedSyncbaseBlessings, sgId, myInfo, _opts);
    }

    @Override
    public ListenableFuture<Void> leaveSyncgroup(VContext _context, Id sgId) {
        return this.implSyncgroupManager.leaveSyncgroup(_context, sgId);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> leaveSyncgroup(VContext _context, Id sgId, Options _opts) {
        return this.implSyncgroupManager.leaveSyncgroup(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<Void> leaveSyncgroup(VContext _context, Id sgId, RpcOptions _opts) {
        return this.implSyncgroupManager.leaveSyncgroup(_context, sgId, _opts);
    }

    @Override
    public ListenableFuture<List<Id>> listSyncgroups(VContext _context) {
        return this.implSyncgroupManager.listSyncgroups(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<List<Id>> listSyncgroups(VContext _context, Options _opts) {
        return this.implSyncgroupManager.listSyncgroups(_context, _opts);
    }

    @Override
    public ListenableFuture<List<Id>> listSyncgroups(VContext _context, RpcOptions _opts) {
        return this.implSyncgroupManager.listSyncgroups(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setSyncgroupSpec(VContext _context, Id sgId, SyncgroupSpec spec, String version) {
        return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setSyncgroupSpec(VContext _context, Id sgId, SyncgroupSpec spec, String version, Options _opts) {
        return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setSyncgroupSpec(VContext _context, Id sgId, SyncgroupSpec spec, String version, RpcOptions _opts) {
        return this.implSyncgroupManager.setSyncgroupSpec(_context, sgId, spec, version, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req) {
        return this.implGlobWatcher.watchGlob(_context, req);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, Options _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, RpcOptions _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }
}

