/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.ConflictInfo;
import io.v.v23.services.syncbase.ConflictManagerServer;
import io.v.v23.services.syncbase.ResolutionInfo;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ConflictManagerServerWrapper {
    private final ConflictManagerServer server;

    public ConflictManagerServerWrapper(ConflictManagerServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("startConflictResolver", "// StartConflictResolver registers a resolver for the database that is// associated with this ConflictManager and creates a stream to receive// conflicts and send resolutions.// Batches of ConflictInfos will be sent over with the Continued field// within the ConflictInfo representing the batch boundary. Client must// respond with a batch of ResolutionInfos in the same fashion.// A key is under conflict if two different values were written to it// concurrently (in logical time), i.e. neither value is an ancestor of the// other in the history graph.// A key under conflict can be a part of a batch committed on local or// remote or both syncbases. ConflictInfos for all keys in these two batches// are grouped together. These keys may themselves be under conflict; the// presented batch is a transitive closure of all batches containing keys// under conflict.// For example, for local batch {key1, key2} and remote batch {key1, key3},// the batch sent for conflict resolution will be {key1, key2, key3}.// If there was another concurrent batch {key2, key4}, then the batch sent// for conflict resolution will be {key1, key2, key3, key4}.", inArgs, outArgs, null, null, tags));
        return new Interface("ConflictManager", "io.v.v23.services.syncbase", "// ConflictManager interface provides all the methods necessary to handle// conflict resolution for a given database.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("startConflictResolver".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"startConflictResolver\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> startConflictResolver(VContext _ctx, final StreamServerCall _call) {
        ServerStream<ConflictInfo, ResolutionInfo> _stream = new ServerStream<ConflictInfo, ResolutionInfo>(){

            @Override
            public ListenableFuture<Void> send(ConflictInfo _item) {
                Class<ConflictInfo> _type = ConflictInfo.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<ResolutionInfo> recv() {
                Class<ResolutionInfo> _type = ResolutionInfo.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, ResolutionInfo>(){

                    public ResolutionInfo apply(Object result) {
                        return (ResolutionInfo)result;
                    }
                });
            }
        };
        return this.server.startConflictResolver(_ctx, _call, _stream);
    }
}

