/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.BatchHandle;
import io.v.v23.services.syncbase.CollectionServer;
import io.v.v23.services.syncbase.KeyValue;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class CollectionServerWrapper {
    private final CollectionServer server;

    public CollectionServerWrapper(CollectionServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("create", "// Create creates this Collection. Permissions must be non-nil and include at// least one admin.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("destroy", "// Destroy destroys this Collection, permanently removing all of its data.// TODO(sadovsky): Specify what happens to syncgroups.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("exists", "// Exists returns true only if this Collection exists. Insufficient// permissions cause Exists to return false instead of an error.// TODO(ivanpi): Exists may fail with an error if higher levels of hierarchy// do not exist.// TODO(ivanpi): Temporarily set to Read access because Resolve is now invalid// on Collection.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("getPermissions", "// GetPermissions returns the current Permissions for the Collection.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("setPermissions", "// SetPermissions replaces the current Permissions for the Collection.// Permissions must include at least one admin.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("deleteRange", "// DeleteRange deletes all rows in the given half-open range [start, limit).// If limit is \"\", all rows with keys >= start are included.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BatchHandle.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)byte[].class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("scan", "// Scan returns all rows in the given half-open range [start, limit). If limit// is \"\", all rows with keys >= start are included.// Concurrency semantics are documented in model.go.// Note, we use []byte rather than string for start and limit because they// need not be valid UTF-8; VDL expects strings to be valid UTF-8.", inArgs, outArgs, null, null, tags));
        return new Interface("Collection", "io.v.v23.services.syncbase", "// Collection represents a set of Rows.// Collection.Glob operates over keys of Rows in the Collection.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("create".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
            }
        }
        if ("deleteRange".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"deleteRange\": %s", e.getMessage()));
            }
        }
        if ("destroy".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"destroy\": %s", e.getMessage()));
            }
        }
        if ("exists".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"exists\": %s", e.getMessage()));
            }
        }
        if ("getPermissions".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getPermissions\": %s", e.getMessage()));
            }
        }
        if ("scan".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"scan\": %s", e.getMessage()));
            }
        }
        if ("setPermissions".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"setPermissions\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> create(VContext _ctx, StreamServerCall _call, BatchHandle bh, Permissions perms) {
        return this.server.create(_ctx, _call, bh, perms);
    }

    public ListenableFuture<Void> destroy(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.destroy(_ctx, _call, bh);
    }

    public ListenableFuture<Boolean> exists(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.exists(_ctx, _call, bh);
    }

    public ListenableFuture<Permissions> getPermissions(VContext _ctx, StreamServerCall _call, BatchHandle bh) {
        return this.server.getPermissions(_ctx, _call, bh);
    }

    public ListenableFuture<Void> setPermissions(VContext _ctx, StreamServerCall _call, BatchHandle bh, Permissions perms) {
        return this.server.setPermissions(_ctx, _call, bh, perms);
    }

    public ListenableFuture<Void> deleteRange(VContext _ctx, StreamServerCall _call, BatchHandle bh, byte[] start, byte[] limit) {
        return this.server.deleteRange(_ctx, _call, bh, start, limit);
    }

    public ListenableFuture<Void> scan(VContext _ctx, final StreamServerCall _call, BatchHandle bh, byte[] start, byte[] limit) {
        ServerStream<KeyValue, Void> _stream = new ServerStream<KeyValue, Void>(){

            @Override
            public ListenableFuture<Void> send(KeyValue _item) {
                Class<KeyValue> _type = KeyValue.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.scan(_ctx, _call, bh, start, limit, (ServerSendStream<KeyValue>)_stream);
    }
}

