/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.syncbase.BlobFetchStatus;
import io.v.v23.services.syncbase.BlobManagerServer;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.vdl.ServerRecvStream;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class BlobManagerServerWrapper {
    private final BlobManagerServer server;

    public BlobManagerServerWrapper(BlobManagerServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("createBlob", "// CreateBlob returns a BlobRef for a newly created blob.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("putBlob", "// PutBlob appends the byte stream to the blob.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("commitBlob", "// CommitBlob marks the blob as immutable.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getBlobSize", "// GetBlobSize returns the count of bytes written as part of the blob// (committed or uncommitted).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("deleteBlob", "// DeleteBlob locally deletes the blob (committed or uncommitted).", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("getBlob", "// GetBlob returns the byte stream from a committed blob starting at offset.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlUint64.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("fetchBlob", "// FetchBlob initiates fetching a blob if not locally found. priority// controls the network priority of the blob. Higher priority blobs are// fetched before the lower priority ones. However, an ongoing blob// transfer is not interrupted. Status updates are streamed back to the// client as fetch is in progress.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("pinBlob", "// PinBlob locally pins the blob so that it is not evicted.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("unpinBlob", "// UnpinBlob locally unpins the blob so that it can be evicted if needed.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlobRef.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlUint64.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("keepBlob", "// KeepBlob locally caches the blob with the specified rank. Lower// ranked blobs are more eagerly evicted.", inArgs, outArgs, null, null, tags));
        return new Interface("BlobManager", "io.v.v23.services.syncbase", "// BlobManager is the interface for blob operations.//// Description of API for resumable blob creation (append-only):// - Up until commit, a BlobRef may be used with PutBlob, GetBlobSize,//   DeleteBlob, and CommitBlob. Blob creation may be resumed by obtaining the//   current blob size via GetBlobSize and appending to the blob via PutBlob.// - After commit, a blob is immutable, at which point PutBlob and CommitBlob//   may no longer be used.// - All other methods (GetBlob, FetchBlob, PinBlob, etc.) may only be used//   after commit.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("commitBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"commitBlob\": %s", e.getMessage()));
            }
        }
        if ("createBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"createBlob\": %s", e.getMessage()));
            }
        }
        if ("deleteBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"deleteBlob\": %s", e.getMessage()));
            }
        }
        if ("fetchBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"fetchBlob\": %s", e.getMessage()));
            }
        }
        if ("getBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getBlob\": %s", e.getMessage()));
            }
        }
        if ("getBlobSize".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getBlobSize\": %s", e.getMessage()));
            }
        }
        if ("keepBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"keepBlob\": %s", e.getMessage()));
            }
        }
        if ("pinBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"pinBlob\": %s", e.getMessage()));
            }
        }
        if ("putBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"putBlob\": %s", e.getMessage()));
            }
        }
        if ("unpinBlob".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"unpinBlob\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<BlobRef> createBlob(VContext _ctx, StreamServerCall _call) {
        return this.server.createBlob(_ctx, _call);
    }

    public ListenableFuture<Void> putBlob(VContext _ctx, final StreamServerCall _call, BlobRef br) {
        ServerStream<Void, byte[]> _stream = new ServerStream<Void, byte[]>(){

            @Override
            public ListenableFuture<Void> send(Void _item) {
                Class<Void> _type = Void.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                Class<byte[]> _type = byte[].class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, byte[]>(){

                    public byte[] apply(Object result) {
                        return (byte[])result;
                    }
                });
            }
        };
        return this.server.putBlob(_ctx, _call, br, (ServerRecvStream<byte[]>)_stream);
    }

    public ListenableFuture<Void> commitBlob(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.commitBlob(_ctx, _call, br);
    }

    public ListenableFuture<Long> getBlobSize(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.getBlobSize(_ctx, _call, br);
    }

    public ListenableFuture<Void> deleteBlob(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.deleteBlob(_ctx, _call, br);
    }

    public ListenableFuture<Void> getBlob(VContext _ctx, final StreamServerCall _call, BlobRef br, long offset) {
        ServerStream<byte[], Void> _stream = new ServerStream<byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.getBlob(_ctx, _call, br, offset, (ServerSendStream<byte[]>)_stream);
    }

    public ListenableFuture<Void> fetchBlob(VContext _ctx, final StreamServerCall _call, BlobRef br, VdlUint64 priority) {
        ServerStream<BlobFetchStatus, Void> _stream = new ServerStream<BlobFetchStatus, Void>(){

            @Override
            public ListenableFuture<Void> send(BlobFetchStatus _item) {
                Class<BlobFetchStatus> _type = BlobFetchStatus.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.fetchBlob(_ctx, _call, br, priority, (ServerSendStream<BlobFetchStatus>)_stream);
    }

    public ListenableFuture<Void> pinBlob(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.pinBlob(_ctx, _call, br);
    }

    public ListenableFuture<Void> unpinBlob(VContext _ctx, StreamServerCall _call, BlobRef br) {
        return this.server.unpinBlob(_ctx, _call, br);
    }

    public ListenableFuture<Void> keepBlob(VContext _ctx, StreamServerCall _call, BlobRef br, VdlUint64 rank) {
        return this.server.keepBlob(_ctx, _call, br, rank);
    }
}

