/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.syncbase;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.services.syncbase.BlobFetchStatus;
import io.v.v23.services.syncbase.BlobManagerClient;
import io.v.v23.services.syncbase.BlobRef;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientSendStream;
import io.v.v23.vdl.ClientStream;
import io.v.v23.vdl.VdlUint64;
import java.lang.reflect.Type;

final class BlobManagerClientImpl
implements BlobManagerClient {
    private final Client client;
    private final String vName;

    public BlobManagerClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<BlobRef> createBlob(VContext _context) {
        return this.createBlob(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<BlobRef> createBlob(VContext _context, Options _opts) {
        return this.createBlob(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<BlobRef> createBlob(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "createBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BlobRef>(){

            public ListenableFuture<BlobRef> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{BlobRef.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], BlobRef>(){

                    public BlobRef apply(Object[] _results) {
                        return (BlobRef)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientSendStream<byte[], Void> putBlob(VContext _context, BlobRef br) {
        return this.putBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientSendStream<byte[], Void> putBlob(VContext _context, BlobRef br, Options _opts) {
        return this.putBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientSendStream<byte[], Void> putBlob(final VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "putBlob", _args, _argTypes, _opts);
        return new ClientStream<byte[], Void, Void>(){

            @Override
            public ListenableFuture<Void> send(final byte[] item) {
                final Class<byte[]> type = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> recv() {
                final Class<Void> recvType = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, Void>(){

                            public Void apply(Object result) {
                                return (Void)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br) {
        return this.commitBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br, Options _opts) {
        return this.commitBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> commitBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "commitBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br) {
        return this.getBlobSize(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br, Options _opts) {
        return this.getBlobSize(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Long> getBlobSize(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "getBlobSize", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Long>(){

            public ListenableFuture<Long> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Long.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Long>(){

                    public Long apply(Object[] _results) {
                        return (Long)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br) {
        return this.deleteBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br, Options _opts) {
        return this.deleteBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> deleteBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "deleteBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<byte[], Void> getBlob(VContext _context, BlobRef br, long offset) {
        return this.getBlob(_context, br, offset, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<byte[], Void> getBlob(VContext _context, BlobRef br, long offset, Options _opts) {
        return this.getBlob(_context, br, offset, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<byte[], Void> getBlob(final VContext _context, BlobRef br, long offset, RpcOptions _opts) {
        Object[] _args = new Object[]{br, offset};
        Type[] _argTypes = new Type[]{BlobRef.class, Long.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "getBlob", _args, _argTypes, _opts);
        return new ClientStream<Void, byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                final Class<byte[]> recvType = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, byte[]>(){

                    public ListenableFuture<byte[]> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, byte[]>(){

                            public byte[] apply(Object result) {
                                return (byte[])result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(VContext _context, BlobRef br, VdlUint64 priority) {
        return this.fetchBlob(_context, br, priority, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(VContext _context, BlobRef br, VdlUint64 priority, Options _opts) {
        return this.fetchBlob(_context, br, priority, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<BlobFetchStatus, Void> fetchBlob(final VContext _context, BlobRef br, VdlUint64 priority, RpcOptions _opts) {
        Object[] _args = new Object[]{br, priority};
        Type[] _argTypes = new Type[]{BlobRef.class, VdlUint64.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "fetchBlob", _args, _argTypes, _opts);
        return new ClientStream<Void, BlobFetchStatus, Void>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<BlobFetchStatus> recv() {
                final Class<BlobFetchStatus> recvType = BlobFetchStatus.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BlobFetchStatus>(){

                    public ListenableFuture<BlobFetchStatus> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, BlobFetchStatus>(){

                            public BlobFetchStatus apply(Object result) {
                                return (BlobFetchStatus)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br) {
        return this.pinBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br, Options _opts) {
        return this.pinBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> pinBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "pinBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br) {
        return this.unpinBlob(_context, br, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br, Options _opts) {
        return this.unpinBlob(_context, br, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> unpinBlob(VContext _context, BlobRef br, RpcOptions _opts) {
        Object[] _args = new Object[]{br};
        Type[] _argTypes = new Type[]{BlobRef.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "unpinBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank) {
        return this.keepBlob(_context, br, rank, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank, Options _opts) {
        return this.keepBlob(_context, br, rank, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> keepBlob(VContext _context, BlobRef br, VdlUint64 rank, RpcOptions _opts) {
        Object[] _args = new Object[]{br, rank};
        Type[] _argTypes = new Type[]{BlobRef.class, VdlUint64.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "keepBlob", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }
}

