/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.stats;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.stats.StatsServer;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class StatsServerWrapper {
    private final StatsServer server;
    private final GlobWatcherServerWrapper wrapperGlobWatcher;

    public StatsServerWrapper(StatsServer server) {
        this.server = server;
        this.wrapperGlobWatcher = new GlobWatcherServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlAny.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("value", "// Value returns the current value of an object, or an error. The type// of the value is implementation specific.// Some objects may not have a value, in which case, Value() returns// a NoValue error.", inArgs, outArgs, null, null, tags));
        return new Interface("Stats", "io.v.v23.services.stats", "// The Stats interface is used to access stats for troubleshooting and// monitoring purposes. The stats objects are discoverable via the Globbable// interface and watchable via the GlobWatcher interface.//// The types of the object values are implementation specific, but should be// primarily numeric in nature, e.g. counters, memory usage, latency metrics,// etc.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("value".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"value\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperGlobWatcher.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<VdlAny> value(VContext _ctx, StreamServerCall _call) {
        return this.server.value(_ctx, _call);
    }

    public ListenableFuture<Void> watchGlob(VContext ctx, StreamServerCall call, GlobRequest req) throws VException {
        return this.wrapperGlobWatcher.watchGlob(ctx, call, req);
    }
}

