/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.stats;

import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.services.stats.StatsClient;
import io.v.v23.services.watch.Change;
import io.v.v23.services.watch.GlobRequest;
import io.v.v23.services.watch.GlobWatcherClient;
import io.v.v23.services.watch.GlobWatcherClientFactory;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.VdlAny;
import java.lang.reflect.Type;

final class StatsClientImpl
implements StatsClient {
    private final Client client;
    private final String vName;
    private final GlobWatcherClient implGlobWatcher;

    public StatsClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implGlobWatcher = GlobWatcherClientFactory.getGlobWatcherClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<VdlAny> value(VContext _context) {
        return this.value(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<VdlAny> value(VContext _context, Options _opts) {
        return this.value(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<VdlAny> value(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "value", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, VdlAny>(){

            public ListenableFuture<VdlAny> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{VdlAny.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], VdlAny>(){

                    public VdlAny apply(Object[] _results) {
                        return (VdlAny)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req) {
        return this.implGlobWatcher.watchGlob(_context, req);
    }

    @Override
    @Deprecated
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, Options _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }

    @Override
    public ClientRecvStream<Change, Void> watchGlob(VContext _context, GlobRequest req, RpcOptions _opts) {
        return this.implGlobWatcher.watchGlob(_context, req, _opts);
    }
}

