/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.repository;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.binary.PartInfo;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.repository.BinaryServer;
import io.v.v23.services.repository.MediaInfo;
import io.v.v23.vdl.ServerRecvStream;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class BinaryServerWrapper {
    private final BinaryServer server;
    private final ObjectServerWrapper wrapperObject;

    public BinaryServerWrapper(BinaryServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)MediaInfo.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("create", "// Create expresses the intent to create a binary identified by the// object name suffix consisting of the given number of parts. The// mediaInfo argument contains metadata for the binary. If the suffix// identifies a binary that has already been created, the method// returns an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("delete", "// Delete deletes the binary identified by the object name// suffix. If the binary that has not been created, the method// returns an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("download", "// Download opens a stream that can used for downloading the given// part of the binary identified by the object name suffix. If the// binary part has not been uploaded, the method returns an// error. If the Delete() method is invoked when the Download()// method is in progress, the outcome the Download() method is// undefined.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("downloadUrl", "// DownloadUrl returns a transient URL from which the binary// identified by the object name suffix can be downloaded using the// HTTP protocol. If not all parts of the binary have been uploaded,// the method returns an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<PartInfo>>(){}.getType())));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)MediaInfo.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("stat", "// Stat returns information describing the parts of the binary// identified by the object name suffix, and its RFC 2046 media type.// If the binary has not been created, the method returns an error.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("upload", "// Upload opens a stream that can be used for uploading the given// part of the binary identified by the object name suffix. If the// binary has not been created, the method returns an error. If the// binary part has been uploaded, the method returns an error. If// the same binary part is being uploaded by another caller, the// method returns an error.", inArgs, outArgs, null, null, tags));
        return new Interface("Binary", "io.v.v23.services.repository", "// Binary can be used to store and retrieve vanadium application// binaries.//// To create a binary, clients first invoke the Create() method that// specifies the number of parts the binary consists of. Clients then// uploads the individual parts through the Upload() method, which// identifies the part being uploaded. To resume an upload after a// failure, clients invoke the UploadStatus() method, which returns a// slice that identifies which parts are missing.//// To download a binary, clients first invoke Stat(), which returns// information describing the binary, including the number of parts// the binary consists of. Clients then download the individual parts// through the Download() method, which identifies the part being// downloaded. Alternatively, clients can download the binary through// HTTP using a transient URL available through the DownloadUrl()// method.//// To delete the binary, clients invoke the Delete() method.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("create".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
            }
        }
        if ("delete".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
            }
        }
        if ("download".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"download\": %s", e.getMessage()));
            }
        }
        if ("downloadUrl".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"downloadUrl\": %s", e.getMessage()));
            }
        }
        if ("stat".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"stat\": %s", e.getMessage()));
            }
        }
        if ("upload".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"upload\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> create(VContext _ctx, StreamServerCall _call, int nparts, MediaInfo mediaInfo) {
        return this.server.create(_ctx, _call, nparts, mediaInfo);
    }

    public ListenableFuture<Void> delete(VContext _ctx, StreamServerCall _call) {
        return this.server.delete(_ctx, _call);
    }

    public ListenableFuture<Void> download(VContext _ctx, final StreamServerCall _call, int part) {
        ServerStream<byte[], Void> _stream = new ServerStream<byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.download(_ctx, _call, part, (ServerSendStream<byte[]>)_stream);
    }

    public ListenableFuture<BinaryServer.DownloadUrlOut> downloadUrl(VContext _ctx, StreamServerCall _call) {
        return this.server.downloadUrl(_ctx, _call);
    }

    public ListenableFuture<BinaryServer.StatOut> stat(VContext _ctx, StreamServerCall _call) {
        return this.server.stat(_ctx, _call);
    }

    public ListenableFuture<Void> upload(VContext _ctx, final StreamServerCall _call, int part) {
        ServerStream<Void, byte[]> _stream = new ServerStream<Void, byte[]>(){

            @Override
            public ListenableFuture<Void> send(Void _item) {
                Class<Void> _type = Void.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                Class<byte[]> _type = byte[].class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, byte[]>(){

                    public byte[] apply(Object result) {
                        return (byte[])result;
                    }
                });
            }
        };
        return this.server.upload(_ctx, _call, part, (ServerRecvStream<byte[]>)_stream);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }
}

