/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.repository;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.binary.PartInfo;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import io.v.v23.services.repository.BinaryClient;
import io.v.v23.services.repository.MediaInfo;
import io.v.v23.vdl.ClientRecvStream;
import io.v.v23.vdl.ClientSendStream;
import io.v.v23.vdl.ClientStream;
import java.lang.reflect.Type;
import java.util.List;

final class BinaryClientImpl
implements BinaryClient {
    private final Client client;
    private final String vName;
    private final ObjectClient implObject;

    public BinaryClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, int nparts, MediaInfo mediaInfo) {
        return this.create(_context, nparts, mediaInfo, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> create(VContext _context, int nparts, MediaInfo mediaInfo, Options _opts) {
        return this.create(_context, nparts, mediaInfo, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> create(VContext _context, int nparts, MediaInfo mediaInfo, RpcOptions _opts) {
        Object[] _args = new Object[]{nparts, mediaInfo};
        Type[] _argTypes = new Type[]{Integer.class, MediaInfo.class};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "create", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context) {
        return this.delete(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> delete(VContext _context, Options _opts) {
        return this.delete(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Void> delete(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "delete", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

            public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Void>(){

                    public Void apply(Object[] _results) {
                        return null;
                    }
                });
            }
        }));
    }

    @Override
    public ClientRecvStream<byte[], Void> download(VContext _context, int part) {
        return this.download(_context, part, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientRecvStream<byte[], Void> download(VContext _context, int part, Options _opts) {
        return this.download(_context, part, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientRecvStream<byte[], Void> download(final VContext _context, int part, RpcOptions _opts) {
        Object[] _args = new Object[]{part};
        Type[] _argTypes = new Type[]{Integer.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "download", _args, _argTypes, _opts);
        return new ClientStream<Void, byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(final Void item) {
                final Class<Void> type = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<byte[]> recv() {
                final Class<byte[]> recvType = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, byte[]>(){

                    public ListenableFuture<byte[]> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, byte[]>(){

                            public byte[] apply(Object result) {
                                return (byte[])result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<BinaryClient.DownloadUrlOut> downloadUrl(VContext _context) {
        return this.downloadUrl(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<BinaryClient.DownloadUrlOut> downloadUrl(VContext _context, Options _opts) {
        return this.downloadUrl(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<BinaryClient.DownloadUrlOut> downloadUrl(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "downloadUrl", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BinaryClient.DownloadUrlOut>(){

            public ListenableFuture<BinaryClient.DownloadUrlOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{String.class, Long.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], BinaryClient.DownloadUrlOut>(){

                    public BinaryClient.DownloadUrlOut apply(Object[] _results) {
                        BinaryClient.DownloadUrlOut _ret = new BinaryClient.DownloadUrlOut();
                        _ret.url = (String)_results[0];
                        _ret.ttl = (Long)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<BinaryClient.StatOut> stat(VContext _context) {
        return this.stat(_context, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<BinaryClient.StatOut> stat(VContext _context, Options _opts) {
        return this.stat(_context, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<BinaryClient.StatOut> stat(VContext _context, RpcOptions _opts) {
        Object[] _args = new Object[]{};
        Type[] _argTypes = new Type[]{};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "stat", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, BinaryClient.StatOut>(){

            public ListenableFuture<BinaryClient.StatOut> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{new TypeToken<List<PartInfo>>(){}.getType(), MediaInfo.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], BinaryClient.StatOut>(){

                    public BinaryClient.StatOut apply(Object[] _results) {
                        BinaryClient.StatOut _ret = new BinaryClient.StatOut();
                        _ret.parts = (List)_results[0];
                        _ret.mediaInfo = (MediaInfo)_results[1];
                        return _ret;
                    }
                });
            }
        }));
    }

    @Override
    public ClientSendStream<byte[], Void> upload(VContext _context, int part) {
        return this.upload(_context, part, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ClientSendStream<byte[], Void> upload(VContext _context, int part, Options _opts) {
        return this.upload(_context, part, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ClientSendStream<byte[], Void> upload(final VContext _context, int part, RpcOptions _opts) {
        Object[] _args = new Object[]{part};
        Type[] _argTypes = new Type[]{Integer.class};
        final ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "upload", _args, _argTypes, _opts);
        return new ClientStream<byte[], Void, Void>(){

            @Override
            public ListenableFuture<Void> send(final byte[] item) {
                final Class<byte[]> type = byte[].class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.send(item, type);
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> close() {
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return _call.closeSend();
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> recv() {
                final Class<Void> recvType = Void.class;
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.recv(recvType), (Function)new Function<Object, Void>(){

                            public Void apply(Object result) {
                                return (Void)result;
                            }
                        });
                    }
                }));
            }

            @Override
            public ListenableFuture<Void> finish() {
                final Type[] resultTypes = new Type[]{};
                return VFutures.withUserLandChecks(_context, Futures.transform((ListenableFuture)_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Void>(){

                    public ListenableFuture<Void> apply(ClientCall _call) throws Exception {
                        return Futures.transform(_call.finish(resultTypes), (Function)new Function<Object[], Void>(){

                            public Void apply(Object[] _results) {
                                return null;
                            }
                        });
                    }
                }));
            }
        };
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }
}

