/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.repository;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.application.Envelope;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.services.repository.ApplicationServer;
import io.v.v23.services.tidyable.TidyableServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class ApplicationServerWrapper {
    private final ApplicationServer server;
    private final ObjectServerWrapper wrapperObject;
    private final TidyableServerWrapper wrapperTidyable;

    public ApplicationServerWrapper(ApplicationServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
        this.wrapperTidyable = new TidyableServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Envelope.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Read"), Tag.class)));
        methods.add(new Method("match", "// Match checks if any of the given profiles contains an application// envelope for the given application version (specified through the// object name suffix) and if so, returns this envelope. If multiple// profile matches are possible, the method returns the first// matching profile, respecting the order of the input argument.//// If the version is not specified in the suffix, the envelope// corresponding to the latest version that matches any of the given// profiles is returned.  If several profiles match this version, the// envelope for the first matching profile is returned, respecting the// order of the input argument.", inArgs, outArgs, null, null, tags));
        return new Interface("Application", "io.v.v23.services.repository", "// Application provides access to application envelopes. An// application envelope is identified by an application name and an// application version, which are specified through the object name,// and a profile name, which is specified using a method argument.//// Example:// /apps/search/v1.Match([]string{\"base\", \"media\"})//   returns an application envelope that can be used for downloading//   and executing the \"search\" application, version \"v1\", runnable//   on either the \"base\" or \"media\" profile.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("match".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Read"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"match\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperTidyable.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Envelope> match(VContext _ctx, StreamServerCall _call, List<String> profiles) {
        return this.server.match(_ctx, _call, profiles);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }

    public ListenableFuture<Void> tidyNow(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperTidyable.tidyNow(ctx, call);
    }
}

