/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.repository;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.Options;
import io.v.v23.V;
import io.v.v23.VFutures;
import io.v.v23.context.VContext;
import io.v.v23.options.RpcOptions;
import io.v.v23.rpc.Client;
import io.v.v23.rpc.ClientCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.application.Envelope;
import io.v.v23.services.permissions.ObjectClient;
import io.v.v23.services.permissions.ObjectClientFactory;
import io.v.v23.services.repository.ApplicationClient;
import io.v.v23.services.tidyable.TidyableClient;
import io.v.v23.services.tidyable.TidyableClientFactory;
import java.lang.reflect.Type;
import java.util.List;

final class ApplicationClientImpl
implements ApplicationClient {
    private final Client client;
    private final String vName;
    private final ObjectClient implObject;
    private final TidyableClient implTidyable;

    public ApplicationClientImpl(Client client, String vName) {
        this.client = client;
        this.vName = vName;
        Options opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implObject = ObjectClientFactory.getObjectClient(vName, opts);
        opts = new Options();
        opts.set("io.v.v23.CLIENT", client);
        this.implTidyable = TidyableClientFactory.getTidyableClient(vName, opts);
    }

    private Client getClient(VContext context) {
        return this.client != null ? this.client : V.getClient(context);
    }

    @Override
    public ListenableFuture<Envelope> match(VContext _context, List<String> profiles) {
        return this.match(_context, profiles, (RpcOptions)null);
    }

    @Override
    @Deprecated
    public ListenableFuture<Envelope> match(VContext _context, List<String> profiles, Options _opts) {
        return this.match(_context, profiles, RpcOptions.migrateOptions(_opts));
    }

    @Override
    public ListenableFuture<Envelope> match(VContext _context, List<String> profiles, RpcOptions _opts) {
        Object[] _args = new Object[]{profiles};
        Type[] _argTypes = new Type[]{new TypeToken<List<String>>(){}.getType()};
        ListenableFuture<ClientCall> _callFuture = this.getClient(_context).startCall(_context, this.vName, "match", _args, _argTypes, _opts);
        return VFutures.withUserLandChecks(_context, Futures.transform(_callFuture, (AsyncFunction)new AsyncFunction<ClientCall, Envelope>(){

            public ListenableFuture<Envelope> apply(ClientCall _call) throws Exception {
                Type[] _resultTypes = new Type[]{Envelope.class};
                return Futures.transform(_call.finish(_resultTypes), (Function)new Function<Object[], Envelope>(){

                    public Envelope apply(Object[] _results) {
                        return (Envelope)_results[0];
                    }
                });
            }
        }));
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context) {
        return this.implObject.getPermissions(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, Options _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<ObjectClient.GetPermissionsOut> getPermissions(VContext _context, RpcOptions _opts) {
        return this.implObject.getPermissions(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version) {
        return this.implObject.setPermissions(_context, perms, version);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, Options _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> setPermissions(VContext _context, Permissions perms, String version, RpcOptions _opts) {
        return this.implObject.setPermissions(_context, perms, version, _opts);
    }

    @Override
    public ListenableFuture<Void> tidyNow(VContext _context) {
        return this.implTidyable.tidyNow(_context);
    }

    @Override
    @Deprecated
    public ListenableFuture<Void> tidyNow(VContext _context, Options _opts) {
        return this.implTidyable.tidyNow(_context, _opts);
    }

    @Override
    public ListenableFuture<Void> tidyNow(VContext _context, RpcOptions _opts) {
        return this.implTidyable.tidyNow(_context, _opts);
    }
}

