/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.pprof;

import com.google.common.base.Function;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.pprof.PProfServer;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint64;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public final class PProfServerWrapper {
    private final PProfServer server;

    public PProfServerWrapper(PProfServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("cmdLine", "// CmdLine returns the command-line arguments of the server, including// the name of the executable.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("profiles", "// Profiles returns the list of available profiles.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("profile", "// Profile streams the requested profile. The debug parameter enables// additional output. Passing debug=0 includes only the hexadecimal// addresses that pprof needs. Passing debug=1 adds comments translating// addresses to function names and line numbers, so that a programmer// can read the profile without tools.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("cpuProfile", "// CpuProfile enables CPU profiling for the requested duration and// streams the profile data.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<VdlUint64>>(){}.getType())));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<String>>(){}.getType())));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("symbol", "// Symbol looks up the program counters and returns their respective// function names.", inArgs, outArgs, null, null, tags));
        return new Interface("PProf", "io.v.v23.services.pprof", "", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("cmdLine".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"cmdLine\": %s", e.getMessage()));
            }
        }
        if ("cpuProfile".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"cpuProfile\": %s", e.getMessage()));
            }
        }
        if ("profile".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"profile\": %s", e.getMessage()));
            }
        }
        if ("profiles".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"profiles\": %s", e.getMessage()));
            }
        }
        if ("symbol".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"symbol\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<List<String>> cmdLine(VContext _ctx, StreamServerCall _call) {
        return this.server.cmdLine(_ctx, _call);
    }

    public ListenableFuture<List<String>> profiles(VContext _ctx, StreamServerCall _call) {
        return this.server.profiles(_ctx, _call);
    }

    public ListenableFuture<Void> profile(VContext _ctx, final StreamServerCall _call, String name, int debug) {
        ServerStream<byte[], Void> _stream = new ServerStream<byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.profile(_ctx, _call, name, debug, (ServerSendStream<byte[]>)_stream);
    }

    public ListenableFuture<Void> cpuProfile(VContext _ctx, final StreamServerCall _call, int seconds) {
        ServerStream<byte[], Void> _stream = new ServerStream<byte[], Void>(){

            @Override
            public ListenableFuture<Void> send(byte[] _item) {
                Class<byte[]> _type = byte[].class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.cpuProfile(_ctx, _call, seconds, (ServerSendStream<byte[]>)_stream);
    }

    public ListenableFuture<List<String>> symbol(VContext _ctx, StreamServerCall _call, List<VdlUint64> programCounters) {
        return this.server.symbol(_ctx, _call, programCounters);
    }
}

