/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.permissions;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class ObjectServerWrapper {
    private final ObjectServer server;

    public ObjectServerWrapper(ObjectServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("setPermissions", "// SetPermissions replaces the current Permissions for an object.  version// allows for optional, optimistic concurrency control.  If non-empty,// version's value must come from GetPermissions.  If any client has// successfully called SetPermissions in the meantime, the version will be// stale and SetPermissions will fail.  If empty, SetPermissions performs an// unconditional update.//// Permissions objects are expected to be small.  It is up to the// implementation to define the exact limit, though it should probably be// around 100KB.  Large lists of principals can be represented concisely using// blessings.//// There is some ambiguity when calling SetPermissions on a mount point.// Does it affect the mount itself or does it affect the service endpoint// that the mount points to?  The chosen behavior is that it affects the// service endpoint.  To modify the mount point's Permissions, use// ResolveToMountTable to get an endpoint and call SetPermissions on that.// This means that clients must know when a name refers to a mount point to// change its Permissions.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)));
        methods.add(new Method("getPermissions", "// GetPermissions returns the complete, current Permissions for an object. The// returned version can be passed to a subsequent call to SetPermissions for// optimistic concurrency control. A successful call to SetPermissions will// invalidate version, and the client must call GetPermissions again to get// the current version.", inArgs, outArgs, null, null, tags));
        return new Interface("Object", "io.v.v23.services.permissions", "// Object provides access control for Vanadium objects.//// Vanadium services implementing dynamic access control would typically embed// this interface and tag additional methods defined by the service with one of// Admin, Read, Write, Resolve etc. For example, the VDL definition of the// object would be:////   package mypackage////   import \"v.io/v23/security/access\"//   import \"v.io/v23/services/permissions\"////   type MyObject interface {//     permissions.Object//     MyRead() (string, error) {access.Read}//     MyWrite(string) error    {access.Write}//   }//// If the set of pre-defined tags is insufficient, services may define their// own tag type and annotate all methods with this new type.//// Instead of embedding this Object interface, define SetPermissions and// GetPermissions in their own interface. Authorization policies will typically// respect annotations of a single type. For example, the VDL definition of an// object would be:////  package mypackage////  import \"v.io/v23/security/access\"////  type MyTag string////  const (//    Blue = MyTag(\"Blue\")//    Red  = MyTag(\"Red\")//  )////  type MyObject interface {//    MyMethod() (string, error) {Blue}////    // Allow clients to change access via the access.Object interface://    SetPermissions(perms access.Permissions, version string) error         {Red}//    GetPermissions() (perms access.Permissions, version string, err error) {Blue}//  }", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("getPermissions".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"getPermissions\": %s", e.getMessage()));
            }
        }
        if ("setPermissions".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Admin"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"setPermissions\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Void> setPermissions(VContext _ctx, StreamServerCall _call, Permissions perms, String version) {
        return this.server.setPermissions(_ctx, _call, perms, version);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext _ctx, StreamServerCall _call) {
        return this.server.getPermissions(_ctx, _call);
    }
}

