/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.mounttable;

import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.naming.MountEntry;
import io.v.v23.naming.MountFlag;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.services.mounttable.MountTableServer;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlUint32;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class MountTableServerWrapper {
    private final MountTableServer server;
    private final ObjectServerWrapper wrapperObject;

    public MountTableServerWrapper(MountTableServer server) {
        this.server = server;
        this.wrapperObject = new ObjectServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)VdlUint32.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)MountFlag.class))));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        methods.add(new Method("mount", "// Mount Server (a global name) onto the receiver.//// Subsequent mounts add to the servers mounted there.  The multiple// servers are considered equivalent and are meant solely for// availability, i.e., no load balancing is guaranteed.//// The ttl is the number of seconds the mount is to last unless refreshed by// another mount of the same server.  A ttl of 0 represents an infinite// duration.  A server with an expired ttl should never appear in the results// nor affect the operation of any MountTable method, and should act as if it// was never present as far as the interface is concerned.//// The flags represent a bit mask of options.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("unmount", "// Unmount removes server from the receiver.  If server is empty, remove all// servers mounted there.  Returns a non-nil error iff server remains mounted// at the mount point.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        methods.add(new Method("delete", "// Delete removes the receiver.  If the receiver has children, it will not// be removed unless deleteSubtree is true in which case the whole subtree is// removed.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)MountEntry.class))));
        tags = new ArrayList();
        methods.add(new Method("resolveStep", "// ResolveStep takes the next step in resolving a name.  Returns the next// servers to query and the suffix at those servers.", inArgs, outArgs, null, null, tags));
        return new Interface("MountTable", "io.v.v23.services.mounttable", "// MountTable defines the interface to talk to a mounttable.//// In all methods of MountTable, the receiver is the name bound to.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("delete".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
            }
        }
        if ("mount".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"mount\": %s", e.getMessage()));
            }
        }
        if ("resolveStep".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"resolveStep\": %s", e.getMessage()));
            }
        }
        if ("unmount".equals(method)) {
            try {
                return new VdlValue[0];
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"unmount\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> mount(VContext _ctx, StreamServerCall _call, String server, VdlUint32 ttl, MountFlag flags) {
        return this.server.mount(_ctx, _call, server, ttl, flags);
    }

    public ListenableFuture<Void> unmount(VContext _ctx, StreamServerCall _call, String server) {
        return this.server.unmount(_ctx, _call, server);
    }

    public ListenableFuture<Void> delete(VContext _ctx, StreamServerCall _call, boolean deleteSubtree) {
        return this.server.delete(_ctx, _call, deleteSubtree);
    }

    public ListenableFuture<MountEntry> resolveStep(VContext _ctx, StreamServerCall _call) {
        return this.server.resolveStep(_ctx, _call);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }
}

