/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.logreader;

import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Tag;
import io.v.v23.services.logreader.LogEntry;
import io.v.v23.services.logreader.LogFileServer;
import io.v.v23.vdl.ServerSendStream;
import io.v.v23.vdl.ServerStream;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;

public final class LogFileServerWrapper {
    private final LogFileServer server;

    public LogFileServerWrapper(LogFileServer server) {
        this.server = server;
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("size", "// Size returns the number of bytes in the receiving object.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Integer.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Boolean.class))));
        outArgs = new ArrayList();
        outArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)Long.class))));
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)));
        methods.add(new Method("readLog", "// ReadLog receives up to numEntries log entries starting at the// startPos offset (in bytes) in the receiving object. Each stream chunk// contains one log entry.//// If follow is true, ReadLog will block and wait for more entries to// arrive when it reaches the end of the file.//// ReadLog returns the position where it stopped reading, i.e. the// position where the next entry starts. This value can be used as// startPos for successive calls to ReadLog.//// The returned error will be EndOfFile if and only if ReadLog reached the// end of the file and no log entries were returned.", inArgs, outArgs, null, null, tags));
        return new Interface("LogFile", "io.v.v23.services.logreader", "// LogFile can be used to access log files remotely.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("readLog".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"readLog\": %s", e.getMessage()));
            }
        }
        if ("size".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Debug"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"size\": %s", e.getMessage()));
            }
        }
        return null;
    }

    public ListenableFuture<Long> size(VContext _ctx, StreamServerCall _call) {
        return this.server.size(_ctx, _call);
    }

    public ListenableFuture<Long> readLog(VContext _ctx, final StreamServerCall _call, long startPos, int numEntries, boolean follow) {
        ServerStream<LogEntry, Void> _stream = new ServerStream<LogEntry, Void>(){

            @Override
            public ListenableFuture<Void> send(LogEntry _item) {
                Class<LogEntry> _type = LogEntry.class;
                return _call.send(_item, (Type)((Object)_type));
            }

            @Override
            public ListenableFuture<Void> recv() {
                Class<Void> _type = Void.class;
                return Futures.transform(_call.recv((Type)((Object)_type)), (Function)new Function<Object, Void>(){

                    public Void apply(Object result) {
                        return (Void)result;
                    }
                });
            }
        };
        return this.server.readLog(_ctx, _call, startPos, numEntries, follow, (ServerSendStream<LogEntry>)_stream);
    }
}

