/*
 * Decompiled with CFR 0.152.
 */
package io.v.v23.services.groups;

import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import io.v.v23.context.VContext;
import io.v.v23.rpc.StreamServerCall;
import io.v.v23.security.access.Permissions;
import io.v.v23.security.access.Tag;
import io.v.v23.services.groups.ApproximationType;
import io.v.v23.services.groups.BlessingPatternChunk;
import io.v.v23.services.groups.GetRequest;
import io.v.v23.services.groups.GroupReaderServer;
import io.v.v23.services.groups.GroupReaderServerWrapper;
import io.v.v23.services.groups.GroupServer;
import io.v.v23.services.permissions.ObjectServer;
import io.v.v23.services.permissions.ObjectServerWrapper;
import io.v.v23.vdl.VdlAny;
import io.v.v23.vdl.VdlTypeObject;
import io.v.v23.vdl.VdlValue;
import io.v.v23.vdlroot.signature.Arg;
import io.v.v23.vdlroot.signature.Embed;
import io.v.v23.vdlroot.signature.Interface;
import io.v.v23.vdlroot.signature.Method;
import io.v.v23.verror.VException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class GroupServerWrapper {
    private final GroupServer server;
    private final GroupReaderServerWrapper wrapperGroupReader;
    private final ObjectServerWrapper wrapperObject;

    public GroupServerWrapper(GroupServer server) {
        this.server = server;
        this.wrapperGroupReader = new GroupReaderServerWrapper(server);
        this.wrapperObject = new ObjectServerWrapper(server);
    }

    public Interface signature() {
        ArrayList<Embed> embeds = new ArrayList<Embed>();
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<Arg> inArgs = new ArrayList<Arg>();
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<Permissions>(){}.getType())));
        inArgs.add(new Arg("", "", new VdlTypeObject(new TypeToken<List<BlessingPatternChunk>>(){}.getType())));
        ArrayList<Arg> outArgs = new ArrayList<Arg>();
        ArrayList<VdlAny> tags = new ArrayList<VdlAny>();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("create", "// Create creates a new group if it doesn't already exist.// If perms is nil, a default Permissions is used, providing Admin access to// the caller.// Create requires the caller to have Write permission at the GroupServer.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("delete", "// Delete deletes the group.// Permissions for all group-related methods except Create() are checked// against the Group object.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlessingPatternChunk.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("add", "// Add adds an entry to the group.", inArgs, outArgs, null, null, tags));
        inArgs = new ArrayList();
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)BlessingPatternChunk.class))));
        inArgs.add(new Arg("", "", new VdlTypeObject((Type)((Object)String.class))));
        outArgs = new ArrayList();
        tags = new ArrayList();
        tags.add(new VdlAny(VdlValue.valueOf((Object)new Tag("Write"), Tag.class)));
        methods.add(new Method("remove", "// Remove removes an entry from the group.", inArgs, outArgs, null, null, tags));
        return new Interface("Group", "io.v.v23.services.groups", "// A group's version covers its Permissions as well as any other data stored in// the group. Clients should treat versions as opaque identifiers. For both Get// and Relate, if version is set and matches the Group's current version, the// response will indicate that fact but will otherwise be empty.", embeds, methods);
    }

    public VdlValue[] getMethodTags(String method) throws VException {
        if ("add".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"add\": %s", e.getMessage()));
            }
        }
        if ("create".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"create\": %s", e.getMessage()));
            }
        }
        if ("delete".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"delete\": %s", e.getMessage()));
            }
        }
        if ("remove".equals(method)) {
            try {
                return new VdlValue[]{VdlValue.valueOf((Object)new Tag("Write"), Tag.class)};
            }
            catch (IllegalArgumentException e) {
                throw new VException(String.format("Couldn't get tags for method \"remove\": %s", e.getMessage()));
            }
        }
        VdlValue[] tags = this.wrapperGroupReader.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        tags = this.wrapperObject.getMethodTags(method);
        if (tags != null) {
            return tags;
        }
        return null;
    }

    public ListenableFuture<Void> create(VContext _ctx, StreamServerCall _call, Permissions perms, List<BlessingPatternChunk> entries) {
        return this.server.create(_ctx, _call, perms, entries);
    }

    public ListenableFuture<Void> delete(VContext _ctx, StreamServerCall _call, String version) {
        return this.server.delete(_ctx, _call, version);
    }

    public ListenableFuture<Void> add(VContext _ctx, StreamServerCall _call, BlessingPatternChunk entry, String version) {
        return this.server.add(_ctx, _call, entry, version);
    }

    public ListenableFuture<Void> remove(VContext _ctx, StreamServerCall _call, BlessingPatternChunk entry, String version) {
        return this.server.remove(_ctx, _call, entry, version);
    }

    public ListenableFuture<GroupReaderServer.GetOut> get(VContext ctx, StreamServerCall call, GetRequest req, String reqVersion) throws VException {
        return this.wrapperGroupReader.get(ctx, call, req, reqVersion);
    }

    public ListenableFuture<GroupReaderServer.RelateOut> relate(VContext ctx, StreamServerCall call, Set<String> blessings, ApproximationType hint, String reqVersion, Set<String> visitedGroups) throws VException {
        return this.wrapperGroupReader.relate(ctx, call, blessings, hint, reqVersion, visitedGroups);
    }

    public ListenableFuture<ObjectServer.GetPermissionsOut> getPermissions(VContext ctx, StreamServerCall call) throws VException {
        return this.wrapperObject.getPermissions(ctx, call);
    }

    public ListenableFuture<Void> setPermissions(VContext ctx, StreamServerCall call, Permissions perms, String version) throws VException {
        return this.wrapperObject.setPermissions(ctx, call, perms, version);
    }
}

